package com.amity.socialcloud.sdk.api.core.reaction.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.api.core.reaction.reference.AmityReactionReference
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction
import com.ekoapp.ekosdk.internal.usecase.post.ReactionPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityReactionQuery internal constructor(
    private val reactionReference: AmityReactionReference,
    private val reactionName: String?
) {

    fun query() : Flowable<PagingData<AmityReaction>> {
        return ReactionPagingDataUseCase().execute(
            referenceType = reactionReference.referenceType,
            referenceId = reactionReference.referenceId,
            reactionName = reactionName
        )
    }

    class Builder(private val reactionReference: AmityReactionReference) {

        private var reactionName: String? = null

        fun reactionName(reactionName: String?): Builder {
            return this.apply {
                this.reactionName = reactionName
            }
        }

        fun build(): AmityReactionQuery {
            return AmityReactionQuery(reactionReference, reactionName)
        }
    }

}