package com.amity.socialcloud.sdk.model.core.notificationtray

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.domain.notificationtray.seen.MarkNotificationItemSeenUseCase
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityNotificationTrayItem internal constructor(
    var targetId: String,
    var targetType: String,
    var actionType: String,
    var actionReferenceId: String,
    var actors: List<AmityNotificationTrayActor>? = emptyList(),
    var actorsCount: Int,
    var id: String,
    var daySegment: DateTime?,
    var lastOccurredAt: DateTime?,
    var lastSeenAt: DateTime?,
    var parentId: String,
    var referenceId: String,
    var referenceType: String,
    var templatedText: String,
    var text: String,
    var trayItemCategory: String,
    var isSeen: Boolean? = null,
    var isRecent: Boolean? = null,
    internal var actorUsers: List<AmityUser>? = null,
): Parcelable, ReactorObject {

    fun markSeen(): Completable {
        return MarkNotificationItemSeenUseCase().execute(id)
    }

    fun getUsers(): List<AmityUser>? {
        return actorUsers
    }

    override fun updatedAt(): DateTime? {
        return lastOccurredAt
    }

    override fun uniqueId(): String {
        return id
    }

    companion object {
        internal fun generateUniqueId(targetType: String, targetId: String): String {
            return "$targetType/$targetId"
        }
    }
}