package com.amity.socialcloud.sdk.core.data.ad

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.dto.core.ad.AdsSettingsDto
import com.amity.socialcloud.sdk.dto.core.ad.NetworkAdsDto
import com.amity.socialcloud.sdk.dto.core.ad.toEntity
import io.reactivex.rxjava3.core.Completable


internal class NetworkAdsQueryPersister : QueryPersister<NetworkAdsDto>() {

    override fun persist(dto: NetworkAdsDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files ?: emptyList()))
            .andThen(AdLocalDataStore().saveAdvertisers(dto.advertisers?.map { it.toEntity() } ?: emptyList()))
            .andThen(AdLocalDataStore().saveAdsSettings(dto.settings?.toEntity() ?: AdsSettingsDto().toEntity()))
            .andThen(AdLocalDataStore().saveAds(dto.ads?.map { it.toEntity() } ?: emptyList()))

    }
}