package com.amity.socialcloud.sdk.api.social.member

import com.amity.socialcloud.sdk.api.social.AmitySocialClient
import com.amity.socialcloud.sdk.social.domain.community.moderation.AddRolesUseCase
import com.amity.socialcloud.sdk.social.domain.community.moderation.BanUsersCommunityUseCase
import com.amity.socialcloud.sdk.social.domain.community.moderation.RemoveRolesUseCase
import com.amity.socialcloud.sdk.social.domain.community.moderation.UnBanUsersCommunityUseCase
import com.amity.socialcloud.sdk.social.domain.community.participation.AddUsersCommunityParticipationUseCase
import com.amity.socialcloud.sdk.social.domain.community.participation.RemoveUsersCommunityParticipationUseCase
import io.reactivex.rxjava3.core.Completable


class AmityCommunityModeration internal constructor(private val communityId: String) {

    /* begin_public_function
	  id: community.moderation.add_roles
	*/
    /**
     * add roles to members in a community
     * @param [roles] a list of roleId
     * @param [userIds] a list of userId
     * @return Async completion as Completable
     */
    fun addRoles(roles: List<String>, userIds: List<String>): Completable {
        return AddRolesUseCase().execute(communityId, roles, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: community.moderation.remove_roles
	*/
    /**
     * remove roles to members in a community
     * @param [roles] a list of roleId
     * @param [userIds] a list of userId
     * @return Async completion as Completable
     */
    fun removeRoles(roles: List<String>, userIds: List<String>): Completable {
        return RemoveRolesUseCase().execute(communityId, roles, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: community.moderation.ban_members
	*/
    /**
     * ban community members
     * @param [userIds] a list of userId
     * @return Async completion as Completable
     */
    fun banMembers(userIds: List<String>): Completable {
        return BanUsersCommunityUseCase().execute(communityId, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: community.moderation.unban_members
	*/
    /**
     * unban community members
     * @param [userIds] a list of userId
     * @return Async completion as Completable
     */
    fun unbanMembers(userIds: List<String>): Completable {
        return UnBanUsersCommunityUseCase().execute(communityId, userIds)
    }
    /* end_public_function */
}