package com.amity.socialcloud.sdk.api.chat.channel.create

class AmityChannelCreationType internal constructor(private val displayName: String) {

    fun community(): AmityCommunityChannelCreator.Builder {
        return AmityCommunityChannelCreator.Builder(displayName)
    }

    fun live(): AmityLiveChannelCreator.Builder {
        return AmityLiveChannelCreator.Builder(displayName)
    }

    fun conversation(userId: String): AmityConversationChannelCreator.Builder {
        return conversation(setOf(userId))
    }

    fun conversation(userIds: Set<String>): AmityConversationChannelCreator.Builder {
        return AmityConversationChannelCreator.Builder(userIds, displayName)
    }

}