/*
 * Decompiled with CFR 0.152.
 */
package org.amity.diagnostics;

import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.amity.diagnostics.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u001b\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u001b\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/amity/diagnostics/TimberLogger;", "Lorg/amity/diagnostics/Logger;", "name", "", "(Ljava/lang/String;)V", "isDebugEnabled", "", "()Z", "isErrorEnabled", "isInfoEnabled", "isTraceEnabled", "isWarnEnabled", "getName", "()Ljava/lang/String;", "debug", "", "msg", "t", "", "error", "info", "isLoggable", "level", "", "timber", "Ltimber/log/Timber$Tree;", "trace", "warn", "Companion", "amity-sdk_release"})
public final class TimberLogger
implements Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final String TIMBER_FORMAT = "%s";

    public TimberLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final Timber.Tree timber() {
        Timber.Tree tree = Timber.tag((String)this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"tag(name)");
        return tree;
    }

    private final boolean isLoggable(int level) {
        return Log.isLoggable((String)this.getName(), (int)level);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(2);
    }

    @Override
    public void trace(@Nullable String msg) {
        this.timber().v(msg, new Object[0]);
    }

    @Override
    public void trace(@Nullable String msg, @Nullable Throwable t) {
        Object[] objectArray = new Object[]{msg};
        this.timber().v(t, TIMBER_FORMAT, objectArray);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(3);
    }

    @Override
    public void debug(@Nullable String msg) {
        this.timber().d(msg, new Object[0]);
    }

    @Override
    public void debug(@Nullable String msg, @Nullable Throwable t) {
        Object[] objectArray = new Object[]{msg};
        this.timber().d(t, TIMBER_FORMAT, objectArray);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(4);
    }

    @Override
    public void info(@Nullable String msg) {
        this.timber().i(msg, new Object[0]);
    }

    @Override
    public void info(@Nullable String msg, @Nullable Throwable t) {
        Object[] objectArray = new Object[]{msg};
        this.timber().i(t, TIMBER_FORMAT, objectArray);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(5);
    }

    @Override
    public void warn(@Nullable String msg) {
        this.timber().w(msg, new Object[0]);
    }

    @Override
    public void warn(@Nullable String msg, @Nullable Throwable t) {
        Object[] objectArray = new Object[]{msg};
        this.timber().w(t, TIMBER_FORMAT, objectArray);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLoggable(6);
    }

    @Override
    public void error(@Nullable String msg) {
        this.timber().e(msg, new Object[0]);
    }

    @Override
    public void error(@Nullable String msg, @Nullable Throwable t) {
        Object[] objectArray = new Object[]{msg};
        this.timber().e(t, TIMBER_FORMAT, objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/amity/diagnostics/TimberLogger$Companion;", "", "()V", "TIMBER_FORMAT", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

