/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;

@Entity(tableName="api_key")
public class EkoApiKey {
    private static final String SINGLETON_API_KEY_ID = "SINGLETON_API_KEY_ID";
    @PrimaryKey
    @NonNull
    private String id = EkoApiKey.currentApiKeyId();
    private String apiKey;
    private long updateAt = System.currentTimeMillis();

    public static String currentApiKeyId() {
        return SINGLETON_API_KEY_ID;
    }

    @NonNull
    public String getId() {
        return EkoApiKey.currentApiKeyId();
    }

    public void setId(String id) {
        this.id = EkoApiKey.currentApiKeyId();
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(@NonNull String apiKey) {
        this.apiKey = EkoPreconditions.checkValidId(apiKey, "apiKey");
    }

    public long getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public static EkoApiKey create(@NonNull String apiKey) {
        EkoApiKey ekoApiKey = new EkoApiKey();
        ekoApiKey.setApiKey(apiKey);
        return ekoApiKey;
    }
}

