/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.UserSettingsDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class UserSettingsDao_Impl
extends UserSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserSettingsEntity> __insertionAdapterOfUserSettingsEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<UserSettingsEntity> __deletionAdapterOfUserSettingsEntity;
    private final EntityDeletionOrUpdateAdapter<UserSettingsEntity> __updateAdapterOfUserSettingsEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public UserSettingsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserSettingsEntity = new EntityInsertionAdapter<UserSettingsEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_settings` (`settingId`,`isAllowUpdateDisplayName`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.isAllowUpdateDisplayName() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                String _tmp_1 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfUserSettingsEntity = new EntityDeletionOrUpdateAdapter<UserSettingsEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `user_settings` WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
            }
        };
        this.__updateAdapterOfUserSettingsEntity = new EntityDeletionOrUpdateAdapter<UserSettingsEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user_settings` SET `settingId` = ?,`isAllowUpdateDisplayName` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.isAllowUpdateDisplayName() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                String _tmp_1 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                if (value.getSettingId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getSettingId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_settings";
                return "DELETE from user_settings";
            }
        };
    }

    @Override
    public void insertImpl(UserSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserSettingsEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends UserSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUserSettingsEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(UserSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends UserSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUserSettingsEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(UserSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUserSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(UserSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            UserSettingsDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends UserSettingsEntity> objects) {
        this.__db.beginTransaction();
        try {
            UserSettingsDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(UserSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            UserSettingsDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Flowable<UserSettingsEntity> getUserSettings(String settingId) {
        String _sql = "select * from user_settings where settingId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from user_settings where settingId = ?", (int)1);
        int _argIndex = 1;
        if (settingId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, settingId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_settings"}, (Callable)new Callable<UserSettingsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserSettingsEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserSettingsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    UserSettingsEntity _result;
                    int _cursorIndexOfSettingId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"settingId");
                    int _cursorIndexOfIsAllowUpdateDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAllowUpdateDisplayName");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new UserSettingsEntity();
                        String _tmpSettingId = _cursor.isNull(_cursorIndexOfSettingId) ? null : _cursor.getString(_cursorIndexOfSettingId);
                        _result.setSettingId(_tmpSettingId);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsAllowUpdateDisplayName);
                        boolean _tmpIsAllowUpdateDisplayName = _tmp != 0;
                        _result.setAllowUpdateDisplayName(_tmpIsAllowUpdateDisplayName);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = UserSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = UserSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = UserSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    UserSettingsEntity userSettingsEntity = _result;
                    return userSettingsEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

