/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import com.ekoapp.ekosdk.CategoryEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoCategoryObject;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class EkoCategoryDao<EntityType extends EkoCategoryObject> {
    static <EkoObject extends CategoryEkoObject, CategoryObject extends EkoCategoryObject> void update(List<EkoObject> ekoObjects, EkoCategoryDao<CategoryObject> dao, EkoCategoryObject.EkoCategoryFactory<CategoryObject> factory2) {
        for (CategoryEkoObject ekoObject : ekoObjects) {
            EkoCategoryDao.update(ekoObject, dao, factory2);
        }
    }

    static <CategoryObject extends EkoCategoryObject> void update(CategoryEkoObject ekoObject, EkoCategoryDao<CategoryObject> dao, EkoCategoryObject.EkoCategoryFactory<CategoryObject> factory2) {
        Object[] categoryIds = ekoObject.getCategoryIds().toArray(new String[0]);
        ImmutableList list2 = FluentIterable.from((Object[])categoryIds).transform(category -> factory2.create(ekoObject.getId(), (String)category)).toList();
        dao.insert((List<CategoryObject>)list2);
        dao.retainAll(ekoObject.getId(), (String[])categoryIds);
    }

    @Insert(onConflict=1)
    abstract void insert(List<EntityType> var1);

    abstract void retainAll(String var1, String[] var2);
}

