/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoAccountDao_Impl
extends EkoAccountDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoAccount> __insertionAdapterOfEkoAccount;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoAccount> __deletionAdapterOfEkoAccount;
    private final EntityDeletionOrUpdateAdapter<EkoAccount> __updateAdapterOfEkoAccount;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoAccountDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoAccount = new EntityInsertionAdapter<EkoAccount>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `account` (`userId`,`deviceId`,`refreshToken`,`accessToken`,`issuedAt`,`expiresAt`,`aboutToExpireAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoAccount value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getDeviceId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDeviceId());
                }
                if (value.getRefreshToken() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getRefreshToken());
                }
                if (value.getAccessToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAccessToken());
                }
                String _tmp = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getIssuedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getAboutToExpireAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfEkoAccount = new EntityDeletionOrUpdateAdapter<EkoAccount>(__db){

            public String createQuery() {
                return "DELETE FROM `account` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoAccount value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoAccount = new EntityDeletionOrUpdateAdapter<EkoAccount>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `account` SET `userId` = ?,`deviceId` = ?,`refreshToken` = ?,`accessToken` = ?,`issuedAt` = ?,`expiresAt` = ?,`aboutToExpireAt` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoAccount value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getDeviceId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDeviceId());
                }
                if (value.getRefreshToken() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getRefreshToken());
                }
                if (value.getAccessToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAccessToken());
                }
                String _tmp = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getIssuedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getAboutToExpireAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from account";
                return "DELETE from account";
            }
        };
    }

    @Override
    void insert(EkoAccount ekoAccount) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoAccount.insert((Object)ekoAccount);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoAccount account) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoAccount.handle((Object)account);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoAccount ekoAccount) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoAccount.handle((Object)ekoAccount);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoAccount activateAccount(String userId) {
        this.__db.beginTransaction();
        try {
            EkoAccount _result = EkoAccountDao_Impl.super.activateAccount(userId);
            this.__db.setTransactionSuccessful();
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoAccount deactivateAccount(String userId) {
        this.__db.beginTransaction();
        try {
            EkoAccount _result = EkoAccountDao_Impl.super.deactivateAccount(userId);
            this.__db.setTransactionSuccessful();
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void logoutAccount(String userId) {
        this.__db.beginTransaction();
        try {
            EkoAccountDao_Impl.super.logoutAccount(userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Flowable<List<EkoAccount>> getAll() {
        String _sql = "SELECT * from account";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"account"}, (Callable)new Callable<List<EkoAccount>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoAccount> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoAccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfIssuedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"issuedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    int _cursorIndexOfAboutToExpireAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aboutToExpireAt");
                    ArrayList<EkoAccount> _result = new ArrayList<EkoAccount>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoAccount _item = new EkoAccount();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                        _item.setDeviceId(_tmpDeviceId);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        _item.setRefreshToken(_tmpRefreshToken);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        _item.setAccessToken(_tmpAccessToken);
                        String _tmp = _cursor.isNull(_cursorIndexOfIssuedAt) ? null : _cursor.getString(_cursorIndexOfIssuedAt);
                        DateTime _tmpIssuedAt = EkoAccountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _item.setIssuedAt(_tmpIssuedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoAccountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setExpiresAt(_tmpExpiresAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAboutToExpireAt) ? null : _cursor.getString(_cursorIndexOfAboutToExpireAt);
                        DateTime _tmpAboutToExpireAt = EkoAccountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item.setAboutToExpireAt(_tmpAboutToExpireAt);
                        _result.add(_item);
                    }
                    ArrayList<EkoAccount> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<EkoAccount> getCurrentAccountFlowableImpl() {
        String _sql = "SELECT * from account  LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account  LIMIT 1", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"account"}, (Callable)new Callable<EkoAccount>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoAccount call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoAccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoAccount _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfIssuedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"issuedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    int _cursorIndexOfAboutToExpireAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aboutToExpireAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoAccount();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                        _result.setDeviceId(_tmpDeviceId);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        _result.setRefreshToken(_tmpRefreshToken);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        _result.setAccessToken(_tmpAccessToken);
                        String _tmp = _cursor.isNull(_cursorIndexOfIssuedAt) ? null : _cursor.getString(_cursorIndexOfIssuedAt);
                        DateTime _tmpIssuedAt = EkoAccountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setIssuedAt(_tmpIssuedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoAccountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setExpiresAt(_tmpExpiresAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAboutToExpireAt) ? null : _cursor.getString(_cursorIndexOfAboutToExpireAt);
                        DateTime _tmpAboutToExpireAt = EkoAccountDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setAboutToExpireAt(_tmpAboutToExpireAt);
                    } else {
                        _result = null;
                    }
                    EkoAccount ekoAccount = _result;
                    return ekoAccount;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoAccount getCurrentAccountNow() {
        String _sql = "SELECT * from account LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoAccount _result;
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
            int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
            int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
            int _cursorIndexOfIssuedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"issuedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            int _cursorIndexOfAboutToExpireAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aboutToExpireAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoAccount();
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                _result.setDeviceId(_tmpDeviceId);
                String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                _result.setRefreshToken(_tmpRefreshToken);
                String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                _result.setAccessToken(_tmpAccessToken);
                String _tmp = _cursor.isNull(_cursorIndexOfIssuedAt) ? null : _cursor.getString(_cursorIndexOfIssuedAt);
                DateTime _tmpIssuedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setIssuedAt(_tmpIssuedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setExpiresAt(_tmpExpiresAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfAboutToExpireAt) ? null : _cursor.getString(_cursorIndexOfAboutToExpireAt);
                DateTime _tmpAboutToExpireAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setAboutToExpireAt(_tmpAboutToExpireAt);
            } else {
                _result = null;
            }
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoAccount getByIdNow(String userId) {
        String _sql = "SELECT * from account where userId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoAccount _result;
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
            int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
            int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
            int _cursorIndexOfIssuedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"issuedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            int _cursorIndexOfAboutToExpireAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aboutToExpireAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoAccount();
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                _result.setDeviceId(_tmpDeviceId);
                String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                _result.setRefreshToken(_tmpRefreshToken);
                String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                _result.setAccessToken(_tmpAccessToken);
                String _tmp = _cursor.isNull(_cursorIndexOfIssuedAt) ? null : _cursor.getString(_cursorIndexOfIssuedAt);
                DateTime _tmpIssuedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setIssuedAt(_tmpIssuedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setExpiresAt(_tmpExpiresAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfAboutToExpireAt) ? null : _cursor.getString(_cursorIndexOfAboutToExpireAt);
                DateTime _tmpAboutToExpireAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setAboutToExpireAt(_tmpAboutToExpireAt);
            } else {
                _result = null;
            }
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

