/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.user;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSearchMatchType;
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSortOption;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.follow.FollowLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserModelMapper;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.data.user.paging.UserMediator;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption;
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\bJ \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0010J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0010J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\bJ.\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00170\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030!H\u0016J\u0015\u0010\"\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010&\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\n\u001a\u00020\b2\u0006\u0010(\u001a\u00020)\u00a8\u0006*"}, d2={"Lcom/amity/socialcloud/sdk/core/data/user/UserRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/core/user/UserEntity;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "flagUser", "userId", "getDefaultPageSize", "", "getUser", "getUserByIds", "Lio/reactivex/rxjava3/core/Flowable;", "", "userIds", "getUserDtoByIds", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoUserListDto;", "getUserNow", "getUserPagingData", "Landroidx/paging/PagingData;", "keyword", "matchType", "Lcom/amity/socialcloud/sdk/api/core/user/search/AmityUserSearchMatchType;", "sortBy", "Lcom/amity/socialcloud/sdk/api/core/user/search/AmityUserSortOption;", "hasInLocal", "", "isFlaggedByMe", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "notifyUserUpdate", "notifyUserUpdate$amity_sdk_release", "observeFromCache", "queryFromCache", "unflagUser", "updateUser", "option", "Lcom/amity/socialcloud/sdk/model/core/user/UserUpdateOption;", "amity-sdk_release"})
public final class UserRepository
extends AmityObjectRepository<UserEntity, AmityUser> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new UserRemoteDataStore().getUser(objectId).flatMap((Function)fetchAndSave.1.INSTANCE).doOnSuccess((Consumer)fetchAndSave.2.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"UserRemoteDataStore().ge\u2026         .ignoreElement()");
        return completable;
    }

    @Override
    @Nullable
    public UserEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new UserLocalDataStore().getUser(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<UserEntity, AmityUser> mapper() {
        return new UserModelMapper();
    }

    @Override
    @NotNull
    public Flowable<UserEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new UserLocalDataStore().observeUser(objectId);
    }

    @NotNull
    public final Flowable<PagingData<AmityUser>> getUserPagingData(@Nullable String keyword, @Nullable AmityUserSearchMatchType matchType, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        AmityUserSearchMatchType amityUserSearchMatchType = matchType;
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new UserMediator(keyword, amityUserSearchMatchType != null ? amityUserSearchMatchType.getValue() : null, sortBy), (Function0)new Function0<PagingSource<Integer, UserEntity>>(keyword, matchType, sortBy){
            final /* synthetic */ String $keyword;
            final /* synthetic */ AmityUserSearchMatchType $matchType;
            final /* synthetic */ AmityUserSortOption $sortBy;
            {
                this.$keyword = $keyword;
                this.$matchType = $matchType;
                this.$sortBy = $sortBy;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, UserEntity> invoke() {
                return new UserLocalDataStore().getUserPagingSource(this.$keyword, this.$matchType, this.$sortBy);
            }
        }, (ModelMapper)new UserModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    @Nullable
    public final AmityUser getUser(@NotNull String userId) {
        AmityUser amityUser;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserEntity userEntity = new UserLocalDataStore().getUser(userId);
        if (userEntity != null) {
            UserEntity it = userEntity;
            boolean bl = false;
            amityUser = new UserModelMapper().map(it);
        } else {
            amityUser = null;
        }
        return amityUser;
    }

    @Nullable
    public final AmityUser getUserNow(@NotNull String userId) {
        AmityUser amityUser;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserEntity userEntity = new UserLocalDataStore().getUserNow(userId);
        if (userEntity != null) {
            UserEntity it = userEntity;
            boolean bl = false;
            amityUser = new UserModelMapper().map(it);
        } else {
            amityUser = null;
        }
        return amityUser;
    }

    @NotNull
    public final Flowable<List<AmityUser>> getUserByIds(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Flowable flowable = new UserRemoteDataStore().getUserByIds(userIds).flatMap((Function)getUserByIds.1.INSTANCE).flatMapPublisher((Function)getUserByIds.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"UserRemoteDataStore().ge\u2026          }\n            }");
        return flowable;
    }

    @NotNull
    public final Single<AmityUser> updateUser(@NotNull String userId, @NotNull UserUpdateOption option) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Single single = new UserRemoteDataStore().updateUser(userId, option).flatMap((Function)updateUser.1.INSTANCE).flatMap(new Function(this){
            final /* synthetic */ UserRepository this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final SingleSource<? extends AmityUser> apply(@NotNull String userId) {
                SingleSource singleSource;
                Single single;
                Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
                AmityUser amityUser = this.this$0.getUser(userId);
                if (amityUser != null) {
                    AmityUser it = amityUser;
                    boolean bl = false;
                    single = Single.just((Object)it);
                } else {
                    single = null;
                }
                if (single == null) {
                    Single single2 = Single.never();
                    Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"never()");
                    singleSource = (SingleSource)single2;
                } else {
                    singleSource = (SingleSource)single;
                }
                return singleSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fun updateUser(userId: S\u2026ver()\n            }\n    }");
        return single;
    }

    public final boolean hasInLocal(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new UserLocalDataStore().getUser(userId) != null;
    }

    @NotNull
    public final Completable flagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new UserRemoteDataStore().flagUser(userId).flatMapCompletable(new Function(this, userId){
            final /* synthetic */ UserRepository this$0;
            final /* synthetic */ String $userId;
            {
                this.this$0 = $receiver;
                this.$userId = $userId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoUserListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)new UserQueryPersister().persist(it).andThen((CompletableSource)this.this$0.notifyUserUpdate$amity_sdk_release(this.$userId));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun flagUser(userId: Str\u2026rId))\n            }\n    }");
        return completable;
    }

    @NotNull
    public final Completable unflagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new UserRemoteDataStore().unflagUser(userId).flatMapCompletable(new Function(this, userId){
            final /* synthetic */ UserRepository this$0;
            final /* synthetic */ String $userId;
            {
                this.this$0 = $receiver;
                this.$userId = $userId;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoUserListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)new UserQueryPersister().persist(it).andThen((CompletableSource)this.this$0.notifyUserUpdate$amity_sdk_release(this.$userId));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun unflagUser(userId: S\u2026rId))\n            }\n    }");
        return completable;
    }

    @NotNull
    public final Single<Boolean> isFlaggedByMe(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Single single = new UserRemoteDataStore().isFlaggedByMe(userId).map((Function)isFlaggedByMe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"UserRemoteDataStore().is\u2026\"isFlagByMe\").asBoolean }");
        return single;
    }

    @NotNull
    public final Single<EkoUserListDto> getUserDtoByIds(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new UserRemoteDataStore().getUserByIds(userIds);
    }

    @NotNull
    public final Completable notifyUserUpdate$amity_sdk_release(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> UserRepository.notifyUserUpdate$lambda$2(userId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026rUpdate(userId)\n        }");
        return completable;
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    private static final void notifyUserUpdate$lambda$2(String $userId) {
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        new MessageLocalDataStore().notifyUserUpdate($userId);
        new ChannelMembershipLocalDataStore().notifyUserUpdate($userId);
        new CommunityMembershipLocalDataStore().notifyUserUpdate($userId);
        new FollowLocalDataStore().notifyUserUpdate($userId);
    }
}

