/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import android.net.Uri;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageMentionTargetMapper;
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository;
import com.amity.socialcloud.sdk.core.MessageSyncEngine;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.NetworkConnectionEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.NetworkConnectionEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityAudio;
import com.amity.socialcloud.sdk.model.core.file.AmityFile;
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.util.AppContext;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.processors.PublishProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 62\u00020\u0001:\u000267B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010$\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\tH\u0002J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\tJ\b\u0010*\u001a\u00020\fH\u0016J(\u0010+\u001a\u00020\u000e\"\b\b\u0000\u0010,*\u00020-2\u0006\u0010(\u001a\u00020\t2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/H\u0002J\u0010\u00100\u001a\u00020\f2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\tH\u0002J\b\u00104\u001a\u00020\fH\u0002J\b\u00105\u001a\u00020\fH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/amity/socialcloud/sdk/core/MessageSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "attachmentMessageQueue", "Ljava/util/Queue;", "Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$MessageSyncJob;", "attachmentUploadTrigger", "Lio/reactivex/rxjava3/processors/PublishProcessor;", "", "insurerSyncTimer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "isActive", "", "isOnline", "messageSyncTrigger", "singleThreadSchedulers", "Lio/reactivex/rxjava3/core/Scheduler;", "textMessageQueue", "addAttachmentMessageJob", "message", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "emitter", "Lio/reactivex/rxjava3/core/CompletableEmitter;", "attachment", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;", "addTextMessageJob", "destroy", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getAttachmentMessageSyncJob", "getTextMessageSyncJob", "handleException", "throwable", "", "job", "handleMessageAttachmentUpload", "handleTokenExpire", "handleUploadResult", "T", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFileInfo;", "uploadResult", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "syncMessage", "syncMessageJob", "uploadAttachmentJobs", "Companion", "MessageSyncJob", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMessageSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MessageSyncEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,444:1\n1#2:445\n*E\n"})
public final class MessageSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isActive;
    private boolean isOnline;
    @NotNull
    private final PublishProcessor<Unit> messageSyncTrigger;
    @NotNull
    private final PublishProcessor<Unit> attachmentUploadTrigger;
    @NotNull
    private final Queue<MessageSyncJob> textMessageQueue;
    @NotNull
    private final Queue<MessageSyncJob> attachmentMessageQueue;
    @NotNull
    private final Scheduler singleThreadSchedulers;
    @NotNull
    private final Completable insurerSyncTimer;
    private static final long SYNC_INSURER_INTERVAL_MS = 5000L;
    private static final int MAX_RETRY_SYNC = 3;
    private static final int MAX_CONCURRENT_UPLOAD = 5;

    public MessageSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.isActive = Intrinsics.areEqual(sessionStateEventBus.getCurrentEvent(), (Object)SessionState.Established.INSTANCE);
        this.isOnline = true;
        PublishProcessor publishProcessor = PublishProcessor.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishProcessor, (String)"create()");
        this.messageSyncTrigger = publishProcessor;
        PublishProcessor publishProcessor2 = PublishProcessor.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishProcessor2, (String)"create()");
        this.attachmentUploadTrigger = publishProcessor2;
        this.textMessageQueue = new LinkedList();
        this.attachmentMessageQueue = new LinkedList();
        Scheduler scheduler = Schedulers.from((Executor)Executors.newSingleThreadExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"from(Executors.newSingleThreadExecutor())");
        this.singleThreadSchedulers = scheduler;
        Completable completable = Flowable.interval((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS).skipWhile(new Predicate(this){
            final /* synthetic */ MessageSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public final boolean test(long it) {
                return MessageSyncEngine.access$getTextMessageQueue$p(this.this$0).isEmpty() && MessageSyncEngine.access$getAttachmentMessageQueue$p(this.this$0).isEmpty();
            }
        }).flatMapCompletable(new Function(this){
            final /* synthetic */ MessageSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final CompletableSource apply(long it) {
                return (CompletableSource)Completable.fromCallable(() -> insurerSyncTimer.2.apply$lambda$0(this.this$0));
            }

            private static final Unit apply$lambda$0(MessageSyncEngine this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (MessageSyncEngine.access$isActive$p(this$0) && MessageSyncEngine.access$isOnline$p(this$0) && (!((Collection)MessageSyncEngine.access$getTextMessageQueue$p(this$0)).isEmpty() || !((Collection)MessageSyncEngine.access$getAttachmentMessageQueue$p(this$0)).isEmpty())) {
                    MessageSyncEngine.access$syncMessageJob(this$0);
                    MessageSyncEngine.access$uploadAttachmentJobs(this$0);
                }
                return Unit.INSTANCE;
            }
        }).onErrorComplete().subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"interval(SYNC_INSURER_IN\u2026scribeOn(Schedulers.io())");
        this.insurerSyncTimer = completable;
        NetworkConnectionEventBus.INSTANCE.observe().doOnNext(new Consumer(){

            public final void accept(@NotNull NetworkConnectionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof NetworkConnectionEvent.Connected) {
                    isOnline = true;
                    this.syncMessageJob();
                    this.uploadAttachmentJobs();
                } else {
                    isOnline = false;
                }
            }
        }).subscribeOn(Schedulers.io()).subscribe();
        this.insurerSyncTimer.subscribe();
        this.messageSyncTrigger.flatMapCompletable(new Function(){

            @NotNull
            public final CompletableSource apply(@NotNull Unit it) {
                CompletableSource completableSource;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (isActive && isOnline) {
                    Completable completable;
                    MessageSyncJob job = this.getTextMessageSyncJob();
                    if (job != null) {
                        switch (WhenMappings.$EnumSwitchMapping$0[job.getStatus().ordinal()]) {
                            case 1: {
                                if (job.getRetryCount() > 3) {
                                    completable = new MessageLocalDataStore().updateMessageState(job.getMessage().getMessageId(), AmityMessage.State.FAILED).andThen((CompletableSource)Completable.fromCallable(() -> 2.apply$lambda$0(this, job)));
                                    break;
                                }
                                completable = this.syncMessage(job);
                                break;
                            }
                            case 2: 
                            case 3: {
                                completable = Completable.fromCallable(() -> 2.apply$lambda$1(this, job));
                                break;
                            }
                            default: {
                                completable = Completable.complete();
                                break;
                            }
                        }
                    } else {
                        completable = Completable.complete();
                    }
                    completableSource = (CompletableSource)completable;
                } else {
                    completableSource = (CompletableSource)Completable.complete();
                }
                return completableSource;
            }

            private static final Unit apply$lambda$0(MessageSyncEngine this$0, MessageSyncJob $job) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.textMessageQueue.remove($job);
                this$0.syncMessageJob();
                return Unit.INSTANCE;
            }

            private static final Unit apply$lambda$1(MessageSyncEngine this$0, MessageSyncJob $job) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.textMessageQueue.remove($job);
                this$0.syncMessageJob();
                return Unit.INSTANCE;
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[MessageSyncJob.Status.values().length];
                    try {
                        nArray[MessageSyncJob.Status.CREATED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[MessageSyncJob.Status.SYNCED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[MessageSyncJob.Status.FAILED.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }).onErrorComplete().subscribeOn(this.singleThreadSchedulers).subscribe();
        this.messageSyncTrigger.flatMapCompletable(new Function(){

            @NotNull
            public final CompletableSource apply(@NotNull Unit it) {
                CompletableSource completableSource;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (isActive && isOnline) {
                    Completable completable;
                    MessageSyncJob job = this.getAttachmentMessageSyncJob();
                    if (job != null) {
                        switch (WhenMappings.$EnumSwitchMapping$0[job.getStatus().ordinal()]) {
                            case 1: {
                                if (job.getRetryCount() > 3) {
                                    completable = new MessageLocalDataStore().updateMessageState(job.getMessage().getMessageId(), AmityMessage.State.FAILED).andThen((CompletableSource)Completable.fromCallable(() -> 3.apply$lambda$0(this, job)));
                                    break;
                                }
                                completable = this.syncMessage(job);
                                break;
                            }
                            case 2: 
                            case 3: {
                                completable = Completable.fromCallable(() -> 3.apply$lambda$1(this, job));
                                break;
                            }
                            default: {
                                completable = Completable.complete();
                                break;
                            }
                        }
                    } else {
                        completable = Completable.complete();
                    }
                    completableSource = (CompletableSource)completable;
                } else {
                    completableSource = (CompletableSource)Completable.complete();
                }
                return completableSource;
            }

            private static final Unit apply$lambda$0(MessageSyncEngine this$0, MessageSyncJob $job) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.attachmentMessageQueue.remove($job);
                this$0.syncMessageJob();
                return Unit.INSTANCE;
            }

            private static final Unit apply$lambda$1(MessageSyncEngine this$0, MessageSyncJob $job) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.attachmentMessageQueue.remove($job);
                this$0.syncMessageJob();
                return Unit.INSTANCE;
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[MessageSyncJob.Status.values().length];
                    try {
                        nArray[MessageSyncJob.Status.UPLOADED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[MessageSyncJob.Status.SYNCED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[MessageSyncJob.Status.FAILED.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }).onErrorComplete().subscribeOn(this.singleThreadSchedulers).subscribe();
        this.attachmentUploadTrigger.flatMapCompletable(new Function(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CompletableSource apply(@NotNull Unit it) {
                CompletableSource completableSource;
                MessageSyncJob it2;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$filter$iv = attachmentMessageQueue;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (MessageSyncJob)element$iv$iv;
                    boolean bl = false;
                    if (!(it2.getStatus() == MessageSyncJob.Status.UPLOADING)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List it3 = (List)destination$iv$iv;
                boolean bl = false;
                int it22 = 5 - it3.size();
                boolean bl22 = false;
                int availableSlot = it22 < 0 ? 0 : it22;
                if (availableSlot > 0) {
                    void $this$filterTo$iv$iv2;
                    $this$filter$iv = attachmentMessageQueue;
                    $i$f$filter = false;
                    Iterable bl22 = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        it2 = (MessageSyncJob)element$iv$iv;
                        boolean bl3 = false;
                        if (!(it2.getStatus() == MessageSyncJob.Status.CREATED)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List it4 = (List)destination$iv$iv;
                    boolean bl4 = false;
                    int size = Math.min(it4.size(), availableSlot);
                    List list2 = size > 0 ? it4.subList(0, size) : it4;
                    MessageSyncEngine messageSyncEngine = this;
                    List it5 = list2;
                    boolean bl5 = false;
                    completableSource = (CompletableSource)Flowable.fromIterable((Iterable)it5).flatMapCompletable(new Function(messageSyncEngine){
                        final /* synthetic */ MessageSyncEngine this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        @NotNull
                        public final CompletableSource apply(@NotNull MessageSyncJob job) {
                            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
                            return (CompletableSource)this.this$0.handleMessageAttachmentUpload(job).onErrorComplete().subscribeOn(Schedulers.io());
                        }
                    });
                } else {
                    completableSource = (CompletableSource)Completable.complete();
                }
                return completableSource;
            }
        }).onErrorComplete().subscribeOn(Schedulers.io()).subscribe();
    }

    private final void syncMessageJob() {
        this.messageSyncTrigger.onNext((Object)Unit.INSTANCE);
    }

    public final void addTextMessageJob(@NotNull EkoMessageEntity message, @NotNull CompletableEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        MessageSyncJob job = new MessageSyncJob(message, null, emitter, MessageSyncJob.Status.CREATED, 0, 18, null);
        this.textMessageQueue.add(job);
        this.syncMessageJob();
    }

    /*
     * WARNING - void declaration
     */
    private final Completable syncMessage(MessageSyncJob job) {
        void it;
        String string;
        String string2;
        MessageRepository messageRepository;
        String string3;
        String string4;
        String string5;
        String string6;
        JsonObject jsonObject;
        AmityTags amityTags;
        MessageRepository messageRepository2 = new MessageRepository();
        String string7 = job.getMessage().getMessageId();
        String string8 = job.getMessage().getSubChannelId();
        String string9 = job.getMessage().getParentId();
        String string10 = job.getMessage().getType();
        JsonObject jsonObject2 = job.getMessage().getData();
        if (jsonObject2 == null) {
            jsonObject2 = new JsonObject();
        }
        AmityTags amityTags2 = job.getMessage().getTags();
        AmityMessageAttachment amityMessageAttachment = job.getAttachment();
        if (amityMessageAttachment != null) {
            void it2;
            AmityMessageAttachment amityMessageAttachment2 = amityMessageAttachment;
            amityTags = amityTags2;
            jsonObject = jsonObject2;
            string6 = string10;
            string5 = string9;
            string4 = string8;
            string3 = string7;
            messageRepository = messageRepository2;
            boolean bl = false;
            AmityMessageAttachment.FILE_ID fILE_ID = it2 instanceof AmityMessageAttachment.FILE_ID ? (AmityMessageAttachment.FILE_ID)it2 : null;
            string2 = fILE_ID != null ? fILE_ID.getFileId() : null;
            messageRepository2 = messageRepository;
            string7 = string3;
            string8 = string4;
            string9 = string5;
            string10 = string6;
            jsonObject2 = jsonObject;
            amityTags2 = amityTags;
            string = string2;
        } else {
            string = null;
        }
        List<EkoMentioneesDto> list2 = job.getMessage().getMentionees();
        JsonObject jsonObject3 = job.getMessage().getMetadata();
        string2 = string;
        amityTags = amityTags2;
        jsonObject = jsonObject2;
        string6 = string10;
        string5 = string9;
        string4 = string8;
        string3 = string7;
        messageRepository = messageRepository2;
        boolean bl = false;
        List<AmityMentioneeTarget> list3 = new MessageMentionTargetMapper().map((List<EkoMentioneesDto>)it);
        Completable completable = messageRepository.syncMessage(string3, string4, string5, string6, jsonObject, amityTags, string2, jsonObject3, list3).doOnComplete(() -> MessageSyncEngine.syncMessage$lambda$2(job, this)).doOnSubscribe(new Consumer(job){
            final /* synthetic */ MessageSyncJob $job;
            {
                this.$job = $job;
            }

            public final void accept(@NotNull Disposable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$job.setStatus(MessageSyncJob.Status.SYNCING);
            }
        }).onErrorResumeNext(new Function(this, job){
            final /* synthetic */ MessageSyncEngine this$0;
            final /* synthetic */ MessageSyncJob $job;
            {
                this.this$0 = $receiver;
                this.$job = $job;
            }

            @NotNull
            public final CompletableSource apply(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return (CompletableSource)MessageSyncEngine.access$handleException(this.this$0, error, this.$job);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"private fun syncMessage(\u2026ption(error, job)\n\t\t\t}\n\t}");
        return completable;
    }

    private final MessageSyncJob getTextMessageSyncJob() {
        return this.textMessageQueue.peek();
    }

    private final MessageSyncJob getAttachmentMessageSyncJob() {
        return this.attachmentMessageQueue.peek();
    }

    private final void uploadAttachmentJobs() {
        this.attachmentUploadTrigger.onNext((Object)Unit.INSTANCE);
    }

    public final void addAttachmentMessageJob(@NotNull EkoMessageEntity message, @NotNull CompletableEmitter emitter, @NotNull AmityMessageAttachment attachment) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        MessageSyncJob.Status status = attachment instanceof AmityMessageAttachment.URL ? MessageSyncJob.Status.CREATED : MessageSyncJob.Status.UPLOADED;
        MessageSyncJob job = new MessageSyncJob(message, attachment, emitter, status, 0, 16, null);
        this.attachmentMessageQueue.add(job);
        this.uploadAttachmentJobs();
    }

    @NotNull
    public final Completable handleMessageAttachmentUpload(@NotNull MessageSyncJob job) {
        Completable completable;
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        String messageId = job.getMessage().getMessageId();
        AmityMessage.DataType dataType = AmityMessage.DataType.Companion.enumOf(job.getMessage().getType());
        AmityMessageAttachment attachment = job.getAttachment();
        if (attachment instanceof AmityMessageAttachment.URL) {
            Completable completable2 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.UPLOADING);
            Completable completable3 = completable2.andThen((CompletableSource)(switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1 -> new FileRepository().uploadImage(messageId, ((AmityMessageAttachment.URL)attachment).getUri()).flatMapCompletable(new Function(this, job){
                    final /* synthetic */ MessageSyncEngine this$0;
                    final /* synthetic */ MessageSyncJob $job;
                    {
                        this.this$0 = $receiver;
                        this.$job = $job;
                    }

                    @NotNull
                    public final CompletableSource apply(@NotNull AmityUploadResult<AmityImage> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return (CompletableSource)MessageSyncEngine.access$handleUploadResult(this.this$0, this.$job, it);
                    }
                });
                case 2 -> new FileRepository().uploadFile(messageId, ((AmityMessageAttachment.URL)attachment).getUri()).flatMapCompletable(new Function(this, job){
                    final /* synthetic */ MessageSyncEngine this$0;
                    final /* synthetic */ MessageSyncJob $job;
                    {
                        this.this$0 = $receiver;
                        this.$job = $job;
                    }

                    @NotNull
                    public final CompletableSource apply(@NotNull AmityUploadResult<AmityFile> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return (CompletableSource)MessageSyncEngine.access$handleUploadResult(this.this$0, this.$job, it);
                    }
                });
                case 3 -> new FileRepository().uploadAudio(messageId, ((AmityMessageAttachment.URL)attachment).getUri()).flatMapCompletable(new Function(this, job){
                    final /* synthetic */ MessageSyncEngine this$0;
                    final /* synthetic */ MessageSyncJob $job;
                    {
                        this.this$0 = $receiver;
                        this.$job = $job;
                    }

                    @NotNull
                    public final CompletableSource apply(@NotNull AmityUploadResult<AmityAudio> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return (CompletableSource)MessageSyncEngine.access$handleUploadResult(this.this$0, this.$job, it);
                    }
                });
                case 4 -> new FileRepository().uploadVideo(messageId, ((AmityMessageAttachment.URL)attachment).getUri(), AmityContentFeedType.MESSAGE).flatMapCompletable(new Function(this, job){
                    final /* synthetic */ MessageSyncEngine this$0;
                    final /* synthetic */ MessageSyncJob $job;
                    {
                        this.this$0 = $receiver;
                        this.$job = $job;
                    }

                    @NotNull
                    public final CompletableSource apply(@NotNull AmityUploadResult<AmityVideo> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return (CompletableSource)MessageSyncEngine.access$handleUploadResult(this.this$0, this.$job, it);
                    }
                });
                default -> Completable.complete();
            })).doOnSubscribe(new Consumer(job){
                final /* synthetic */ MessageSyncJob $job;
                {
                    this.$job = $job;
                }

                public final void accept(@NotNull Disposable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$job.setStatus(MessageSyncJob.Status.UPLOADING);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"fun handleMessageAttachm\u2026letable.complete()\n\t\t}\n\t}");
            completable = completable3;
        } else {
            this.syncMessageJob();
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"{\n\t\t\tsyncMessageJob()\n\t\t\u2026ompletable.complete()\n\t\t}");
        }
        return completable;
    }

    private final <T extends AmityFileInfo> Completable handleUploadResult(MessageSyncJob job, AmityUploadResult<? extends T> uploadResult) {
        Completable completable;
        AmityUploadResult<? extends T> amityUploadResult = uploadResult;
        if (amityUploadResult instanceof AmityUploadResult.COMPLETE) {
            String fileId = ((AmityFileInfo)((AmityUploadResult.COMPLETE)uploadResult).getFile()).getFileId();
            job.setAttachment(new AmityMessageAttachment.FILE_ID(fileId));
            job.setStatus(MessageSyncJob.Status.UPLOADED);
            this.syncMessageJob();
            Completable completable2 = Completable.complete();
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n\t\t\t\tval fileId = uploa\u2026mpletable.complete()\n\t\t\t}");
            completable = completable2;
        } else if (amityUploadResult instanceof AmityUploadResult.ERROR) {
            completable = this.handleException(((AmityUploadResult.ERROR)uploadResult).getError(), job);
        } else if (amityUploadResult instanceof AmityUploadResult.CANCELLED) {
            job.setStatus(MessageSyncJob.Status.FAILED);
            Completable completable3 = new MessageLocalDataStore().updateMessageState(job.getMessage().getMessageId(), AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, StringsKt.capitalize((String)job.getMessage().getType()) + " upload cancelled", null, AmityError.UNKNOWN, null, 8, null)));
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"{\n\t\t\t\tjob.status = Messa\u2026\t\t\t\t)\n\t\t\t\t\t\t)\n\t\t\t\t\t)\n\t\t\t}");
        } else {
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"{\n\t\t\t\tCompletable.complete()\n\t\t\t}");
        }
        return completable;
    }

    /*
     * Unable to fully structure code
     */
    private final Completable handleException(Throwable throwable, MessageSyncJob job) {
        block5: {
            block6: {
                block4: {
                    error = AmityException.Companion.fromThrowable(throwable);
                    var4_4 = error.getCode();
                    if (var4_4 != AmityError.CONNECTION_ERROR.getCode()) break block4;
                    job.setStatus(MessageSyncJob.Status.CREATED);
                    v0 = Completable.fromCallable((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleException$lambda$3(com.amity.socialcloud.sdk.core.MessageSyncEngine ), ()Ljava/lang/Object;)((MessageSyncEngine)this)).subscribeOn(Schedulers.io());
                    v1 = v0;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"{\n\t\t\t\tjob.status = Messa\u2026eOn(Schedulers.io())\n\t\t\t}");
                    break block5;
                }
                if (var4_4 != AmityError.UNKNOWN.getCode()) break block6;
                v2 = error.getHttpStatusCode$amity_sdk_release();
                var6_5 = 502;
                if (v2 != null && v2 == var6_5) ** GOTO lbl-1000
                v3 = error.getHttpStatusCode$amity_sdk_release();
                var6_5 = 503;
                if (v3 != null && v3 == var6_5) lbl-1000:
                // 2 sources

                {
                    if (job.getAttachment() instanceof AmityMessageAttachment.FILE_ID) {
                        job.setStatus(MessageSyncJob.Status.UPLOADED);
                    } else {
                        job.setStatus(MessageSyncJob.Status.CREATED);
                    }
                    job.setRetryCount(job.getRetryCount() + 1);
                    v4 = Completable.fromCallable((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleException$lambda$4(com.amity.socialcloud.sdk.core.MessageSyncEngine ), ()Ljava/lang/Object;)((MessageSyncEngine)this)).subscribeOn(Schedulers.io());
                } else {
                    job.setStatus(MessageSyncJob.Status.FAILED);
                    job.getEmitter().onError((Throwable)error);
                    v4 = new MessageLocalDataStore().updateMessageState(job.getMessage().getMessageId(), AmityMessage.State.FAILED).andThen((CompletableSource)Completable.fromCallable((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleException$lambda$5(com.amity.socialcloud.sdk.core.MessageSyncEngine ), ()Ljava/lang/Object;)((MessageSyncEngine)this)));
                }
                var5_6 = v4;
                Intrinsics.checkNotNullExpressionValue((Object)var5_6, (String)"{\n\t\t\t\tif (error.httpStat\u2026Job()\n\t\t\t\t\t\t})\n\t\t\t\t}\n\t\t\t}");
                v1 = var5_6;
                break block5;
            }
            job.setStatus(MessageSyncJob.Status.FAILED);
            job.getEmitter().onError((Throwable)error);
            v5 = new MessageLocalDataStore().updateMessageState(job.getMessage().getMessageId(), AmityMessage.State.FAILED).andThen((CompletableSource)Completable.fromCallable((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleException$lambda$6(com.amity.socialcloud.sdk.core.MessageSyncEngine ), ()Ljava/lang/Object;)((MessageSyncEngine)this)));
            v1 = v5;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"{\n\t\t\t\tjob.status = Messa\u2026MessageJob()\n\t\t\t\t\t})\n\t\t\t}");
        }
        return v1;
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        this.isActive = Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE);
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isActive = true;
    }

    @Override
    public void destroy() {
        this.isActive = false;
    }

    @Override
    public void handleTokenExpire() {
        this.isActive = false;
    }

    private static final void syncMessage$lambda$2(MessageSyncJob $job, MessageSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $job.setStatus(MessageSyncJob.Status.SYNCED);
        $job.getEmitter().onComplete();
        this$0.syncMessageJob();
    }

    private static final Unit handleException$lambda$3(MessageSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread.sleep(5000L);
        this$0.syncMessageJob();
        return Unit.INSTANCE;
    }

    private static final Unit handleException$lambda$4(MessageSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread.sleep(5000L);
        this$0.syncMessageJob();
        return Unit.INSTANCE;
    }

    private static final Unit handleException$lambda$5(MessageSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.syncMessageJob();
        return Unit.INSTANCE;
    }

    private static final Unit handleException$lambda$6(MessageSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.syncMessageJob();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Completable access$handleException(MessageSyncEngine $this, Throwable throwable, MessageSyncJob job) {
        return $this.handleException(throwable, job);
    }

    public static final /* synthetic */ Completable access$handleUploadResult(MessageSyncEngine $this, MessageSyncJob job, AmityUploadResult uploadResult) {
        return $this.handleUploadResult(job, uploadResult);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$Companion;", "", "()V", "MAX_CONCURRENT_UPLOAD", "", "MAX_RETRY_SYNC", "SYNC_INSURER_INTERVAL_MS", "", "grantPersistableUriPermissionIfNeeded", "", "uri", "Landroid/net/Uri;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void grantPersistableUriPermissionIfNeeded(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
                try {
                    AppContext.get().getContentResolver().takePersistableUriPermission(uri, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u0001\u001dB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$MessageSyncJob;", "", "message", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "attachment", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;", "emitter", "Lio/reactivex/rxjava3/core/CompletableEmitter;", "status", "Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$MessageSyncJob$Status;", "retryCount", "", "(Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;Lio/reactivex/rxjava3/core/CompletableEmitter;Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$MessageSyncJob$Status;I)V", "getAttachment", "()Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;", "setAttachment", "(Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessageAttachment;)V", "getEmitter", "()Lio/reactivex/rxjava3/core/CompletableEmitter;", "getMessage", "()Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "getRetryCount", "()I", "setRetryCount", "(I)V", "getStatus", "()Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$MessageSyncJob$Status;", "setStatus", "(Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$MessageSyncJob$Status;)V", "Status", "amity-sdk_release"})
    public static final class MessageSyncJob {
        @NotNull
        private final EkoMessageEntity message;
        @Nullable
        private AmityMessageAttachment attachment;
        @NotNull
        private final CompletableEmitter emitter;
        @NotNull
        private Status status;
        private int retryCount;

        public MessageSyncJob(@NotNull EkoMessageEntity message, @Nullable AmityMessageAttachment attachment, @NotNull CompletableEmitter emitter, @NotNull Status status, int retryCount) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.message = message;
            this.attachment = attachment;
            this.emitter = emitter;
            this.status = status;
            this.retryCount = retryCount;
        }

        public /* synthetic */ MessageSyncJob(EkoMessageEntity ekoMessageEntity, AmityMessageAttachment amityMessageAttachment, CompletableEmitter completableEmitter, Status status, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                amityMessageAttachment = null;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            this(ekoMessageEntity, amityMessageAttachment, completableEmitter, status, n);
        }

        @NotNull
        public final EkoMessageEntity getMessage() {
            return this.message;
        }

        @Nullable
        public final AmityMessageAttachment getAttachment() {
            return this.attachment;
        }

        public final void setAttachment(@Nullable AmityMessageAttachment amityMessageAttachment) {
            this.attachment = amityMessageAttachment;
        }

        @NotNull
        public final CompletableEmitter getEmitter() {
            return this.emitter;
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        public final void setStatus(@NotNull Status status) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
            this.status = status;
        }

        public final int getRetryCount() {
            return this.retryCount;
        }

        public final void setRetryCount(int n) {
            this.retryCount = n;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/amity/socialcloud/sdk/core/MessageSyncEngine$MessageSyncJob$Status;", "", "(Ljava/lang/String;I)V", "CREATED", "UPLOADING", "UPLOADED", "SYNCING", "SYNCED", "FAILED", "amity-sdk_release"})
        public static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status CREATED = new Status();
            public static final /* enum */ Status UPLOADING = new Status();
            public static final /* enum */ Status UPLOADED = new Status();
            public static final /* enum */ Status SYNCING = new Status();
            public static final /* enum */ Status SYNCED = new Status();
            public static final /* enum */ Status FAILED = new Status();
            private static final /* synthetic */ Status[] $VALUES;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String value) {
                return Enum.valueOf(Status.class, value);
            }

            static {
                $VALUES = statusArray = new Status[]{Status.CREATED, Status.UPLOADING, Status.UPLOADED, Status.SYNCING, Status.SYNCED, Status.FAILED};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityMessage.DataType.values().length];
            try {
                nArray[AmityMessage.DataType.IMAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmityMessage.DataType.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmityMessage.DataType.AUDIO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmityMessage.DataType.VIDEO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

