package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto

internal class SubChannelCreated : SubChannelEventListener() {

    override fun getEventName(): String {
        return "message-feed.created"
    }
    
    override fun processEvent(dto: SubChannelListDto) {
        super.processEvent(dto)
        MarkerEventBus.publish(MarkerEvent.SubChannelCreated(getEventName(), dto))
    }

    override fun shouldProcessEvent(dto: SubChannelListDto): Boolean {
        return true
    }
}