package com.amity.socialcloud.sdk.chat.data.marker.user

import com.ekoapp.ekosdk.internal.UserMarkerEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

internal class UserMarkerLocalDataStore {
    
    fun observeUserMarker(): Flowable<UserMarkerEntity> {
        return UserDatabase.get().userMarkerDao().get()
    }
    
    fun saveUserMarkers(
        userMarkers: List<UserMarkerEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().userMarkerDao().save(userMarkers)
        }
    }

}