package com.amity.socialcloud.sdk.api.social.comment.create

import com.amity.socialcloud.sdk.model.social.comment.AmityComment

class AmityCommentCreationType internal constructor(
    private val referenceType: String,
    private val referenceId: String,
    private val parentId: String? = null,
    private val commentId: String? = null
) {

    /**
     * @param [text] to add text value to the comment
     * @return the same instance of AmityTextCommentCreator.Builder
     */
    fun text(text: String): AmityTextCommentCreator.Builder {
        return AmityTextCommentCreator.Builder()
            .referenceType(referenceType)
            .referenceId(referenceId)
            .parentId(parentId)
            .commentId(commentId)
            .text(text)
    }

    /**
     * @param [attachments] to add attachments to the comment
     * @return the same instance of AmityTextCommentCreator.Builder
     */
    fun attachments(vararg attachments: AmityComment.Attachment): AmityAttachmentCommentCreator.Builder {
        return AmityAttachmentCommentCreator.Builder()
            .referenceType(referenceType)
            .referenceId(referenceId)
            .parentId(parentId)
            .commentId(commentId)
            .attachments(*attachments)
    }
}