package com.amity.socialcloud.sdk.social.domain.post.create

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostGetUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostCreateUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class ImagePostCreateUseCase : PostCreateUseCase {

    fun execute(
        targetType: String,
        targetId: String,
        images: List<AmityImage>,
        text: String,
        metadata: JsonObject?,
        mentionUserIds: List<String>?
    ): Single<AmityPost> {
        return PostRepository().createPostV4(
            targetType = targetType,
            targetId = targetId,
            data = composeData(text),
            dataType = null,
            attachments = mapAttachments(images, AmityPost.DataType.IMAGE.getApiKey()),
            metadata = metadata,
            mentionees = mapMentionees(mentionUserIds)
        ).flatMap {
            val post = PostGetUseCase().execute(it)
            if (post != null) {
                Single.just(post)
            } else {
                Single.error(
                    AmityException.create(
                        "Post not found",
                        null,
                        AmityError.ITEM_NOT_FOUND
                    )
                )
            }
        }
    }

    private fun composeData(text: String): JsonObject {
        return JsonObject().apply { addProperty("text", text) }
    }

}