package com.amity.socialcloud.sdk.social.data.category.paging

import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategorySortOption
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class CategoryKeyCreator(
    private val sortOption: AmityCommunityCategorySortOption,
    private val isDeleted: Boolean?,
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "sortOption" to sortOption,
            "isDeleted" to (isDeleted?.toString() ?: "null"),
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(isDeleted)
    }

    private fun getConditionStatement(
        isDeleted: Boolean?,
    ): String {
        // filter
        val defaultFilterStatement =
            "community_category.categoryId is not null"

        //isDeleted filter
        val isDeletedFilterStatement = when (isDeleted) {
            null -> {
                ""
            }
            true -> {
                " and community_category.isDeleted = 1"
            }
            false -> {
                " and community_category.isDeleted = 0"
            }
        }

        return defaultFilterStatement +
                isDeletedFilterStatement
    }

}