package com.amity.socialcloud.sdk.chat.data.subchannel.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.ekoapp.ekosdk.internal.SubChannelEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
interface SubChannelPagingDao : DynamicQueryStreamPagingDao<SubChannelEntity> {

    @RawQuery(observedEntities = [SubChannelEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, SubChannelEntity>

    fun getSubChannelPagingSource(
        channelId: String,
        isDeleted: Boolean
    ): PagingSource<Int, SubChannelEntity> {
        val order = AmityPagingDao.Order.DESC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "sub_channel",
                primaryKeyColumnName = "subChannelId",
                nonce = AmityNonce.SUB_CHANNEL_LIST,
                sortColumn = "lastActivity",
                order = order,
                dynamicQueryStreamKeyCreator = SubChannelKeyCreator(
                    channelId = channelId,
                    isDeleted = isDeleted
                )
            )
        )
    }
}