package com.amity.socialcloud.sdk.api.chat.channel.update


import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.ChannelUpdateOption
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.chat.domain.channel.UpdateChannelUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

class AmityChannelUpdate internal constructor(private var channelId: String, private var option: ChannelUpdateOption) {

    fun apply(): Single<AmityChannel> {
        return UpdateChannelUseCase().execute(channelId, option)
    }

    class Builder internal constructor(private val channelId: String) {
        private var displayName: String? = null
        private var avatarFileId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags? = null

        fun displayName(displayName: String): Builder {
            return apply { this.displayName = displayName }
        }

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityChannelUpdate {
            val option = ChannelUpdateOption(
                    displayName = displayName,
                    metadata = metadata,
                    avatarFileId = avatarFileId,
                    tags = tags)

            return AmityChannelUpdate(channelId = channelId, option = option)
        }
    }
}