package com.ekoapp.ekosdk.internal.report

enum class AmityFlagType constructor(val value: String) {
    SPAM("spam"),
    HATE_SPEECH("hate_speech");

    var apiKey = ""

    init {
        apiKey = value
    }

    companion object {
        fun mapTypeByValue(value: String): AmityFlagType {
            values().forEach { valueItem ->
                if (valueItem.apiKey == value) {
                    return valueItem
                }
            }
            return SPAM
        }
    }
}