package com.amity.socialcloud.sdk.core.data.notificationtray

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayItem
import com.google.gson.JsonObject
import org.joda.time.DateTime

internal class NotificationTrayModelMapper :
    ModelMapper<NotificationTrayItemEntity, AmityNotificationTrayItem>() {
    override fun map(entity: NotificationTrayItemEntity): AmityNotificationTrayItem {
        return entity.run {
            AmityNotificationTrayItem(
                targetId = targetId,
                targetType = targetType,
                actionType = actionType ?: "",
                actionReferenceId = actionReferenceId ?: "",
                actors = actors,
                actorsCount = actorsCount ?: 0,
                data = when (AmityNotificationTrayItem.DataType.sealedOf(data)) {
                    AmityNotificationTrayItem.DataType.COMMUNITY -> AmityNotificationTrayItem.Data.COMMUNITY(serializeCommunityName(data), data)
                    AmityNotificationTrayItem.DataType.REACTION -> AmityNotificationTrayItem.Data.REACTION(serializeReactionNames(data), data)
                    else -> AmityNotificationTrayItem.Data.CUSTOM(data)
                },
                id = notificationId,
                daySegment = daySegment,
                lastOccurredAt = lastOccurredAt,
                lastSeenAt = lastSeenAt,
                parentId = parentId ?: "",
                referenceId = referenceId ?: "",
                referenceType = referenceType ?: "",
                templatedText = templatedText ?: "",
                text = text ?: "",
                trayItemCategory = trayItemCategory ?: "",
                isSeen = entity.lastSeenAt?.isAfter(entity.lastOccurredAt) == true,
                isRecent = lastOccurredAt?.isAfter(DateTime.now().minusDays(7)) == true
            )
        }
    }

    private fun serializeCommunityName(rawData: JsonObject?): String {
        return rawData?.get("communityName")?.asString ?: ""
    }

    private fun serializeReactionNames(rawData: JsonObject?): List<String> {
        val result = mutableListOf<String>()
        rawData?.let {
            if (it.has("reactionName") && it.get("reactionName").isJsonArray) {
                val jsonArray = it.getAsJsonArray("reactionName")
                jsonArray.forEach { element ->
                    if (element.isJsonPrimitive) {
                        result.add(element.asString)
                    }
                }
            }
        }
        return result
    }
}