package com.amity.socialcloud.sdk.dto.core.notificationtray


import com.ekoapp.ekosdk.internal.api.dto.EkoObjectDto
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName
import org.joda.time.DateTime

data class NotificationTrayItemDto(
    @SerializedName("actionType")
    val actionType: String? = null,
    @SerializedName("actionReferenceId")
    val actionReferenceId: String? = null,
    @SerializedName("actors")
    val actors: List<NotificationTrayItemActorIdDto>? = null,
    @SerializedName("actorsCount")
    val actorsCount: Int? = null,
    @SerializedName("data")
    val data: JsonElement? = null,
    @SerializedName("_id")
    val id: String? = null,
    @SerializedName("daySegment")
    val daySegment: DateTime? = null,
    @SerializedName("lastOccurredAt")
    val lastOccurredAt: DateTime? = null,
    @SerializedName("lastSeenAt")
    val lastSeenAt: DateTime? = null,
    @SerializedName("parentId")
    val parentId: String? = null,
    @SerializedName("referenceId")
    val referenceId: String? = null,
    @SerializedName("referenceType")
    val referenceType: String? = null,
    @SerializedName("targetId")
    val targetId: String? = null,
    @SerializedName("targetType")
    val targetType: String? = null,
    @SerializedName("templatedText")
    val templatedText: String? = null,
    @SerializedName("text")
    val text: String? = null,
    @SerializedName("trayItemCategory")
    val trayItemCategory: String? = null
): EkoObjectDto() {
    fun getData(): JsonObject? {
        return if (data != null && data.isJsonObject) {
            data.asJsonObject
        } else null
    }
}