package com.amity.socialcloud.sdk.api.social.post

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.api.social.post.query.AmityCommunityFeedQuery
import com.amity.socialcloud.sdk.api.social.post.query.AmityCustomRankingGlobalFeedQuery
import com.amity.socialcloud.sdk.api.social.post.query.AmityGlobalFeedQuery
import com.amity.socialcloud.sdk.api.social.post.query.AmityUserFeedQuery

class AmityFeedRepository internal constructor() {

    /* begin_public_function
      id: feed.query.global_feed
      api_style: live_collection
    */
    /**
     * Initiates a function chain to query for Global feed.
     * @return new instance of AmityGlobalFeedQuery.Builder.
     */
    fun getGlobalFeed(): AmityGlobalFeedQuery.Builder {
        return AmityGlobalFeedQuery.Builder()
    }
    /* end_public_function */

    /* begin_public_function
      id: feed.query.custom_ranking_feed
      api_style: live_collection
    */
    /**
     * Initiates a function chain to query for custom ranking Global feed.
     * @return new instance of AmityCustomRankingGlobalFeedQuery.Builder.
     */
    fun getCustomRankingGlobalFeed(): AmityCustomRankingGlobalFeedQuery.Builder {
        return AmityCustomRankingGlobalFeedQuery.Builder()
    }
    /* end_public_function */

    /* begin_public_function
      id: feed.query.community_feed
      api_style: live_collection
    */
    /**
     * Initiates a function chain to query for Community feed.
     * @return new instance of AmityCommunityFeedQuery.Builder.
     */
    fun getCommunityFeed(communityId: String): AmityCommunityFeedQuery.Builder {
        return AmityCommunityFeedQuery.Builder(communityId)
    }
    /* end_public_function */

    /* begin_public_function
      id: feed.query.user_feed
      api_style: live_collection
    */
    /**
     * Initiates a function chain to query for User feed.
     * @return new instance of AmityUserFeedQuery.Builder.
     */
    fun getUserFeed(userId: String): AmityUserFeedQuery.Builder {
        return AmityUserFeedQuery.Builder(userId)
    }
    /* end_public_function */

    /**
     * Initiates a function chain to query for my User feed.
     * @return new instance of AmityUserFeedQuery.Builder.
     */
    fun getMyFeed(): AmityUserFeedQuery.Builder {
        return AmityUserFeedQuery.Builder(AmityCoreClient.getUserId())
    }
}
