/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.db;

import android.content.Context;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.zetetic.database.sqlcipher.SQLiteDatabase;
import net.zetetic.database.sqlcipher.SQLiteStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J*\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/amity/socialcloud/sdk/infra/db/DBEncryptionUtils;", "", "<init>", "()V", "getDatabaseState", "Lcom/amity/socialcloud/sdk/infra/db/DBEncryptionUtils$State;", "context", "Landroid/content/Context;", "dbPath", "Ljava/io/File;", "isPassPhraseCorrect", "", "passphrase", "", "encrypt", "", "dbFile", "encryptTo", "originalFile", "targetFile", "decryptTo", "State", "amity-sdk_release"})
public final class DBEncryptionUtils {
    @NotNull
    public static final DBEncryptionUtils INSTANCE = new DBEncryptionUtils();

    private DBEncryptionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final State getDatabaseState(@NotNull Context context, @NotNull File dbPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
        if (dbPath.exists()) {
            State state;
            SQLiteDatabase db = null;
            try {
                db = SQLiteDatabase.openDatabase((String)dbPath.getAbsolutePath(), (String)"", null, (int)1, null);
                db.getVersion();
                state = State.UNENCRYPTED;
            }
            catch (Exception e) {
                state = State.ENCRYPTED;
            }
            finally {
                SQLiteDatabase sQLiteDatabase = db;
                if (sQLiteDatabase != null) {
                    sQLiteDatabase.close();
                }
            }
            return state;
        }
        return State.DOES_NOT_EXIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isPassPhraseCorrect(@NotNull Context context, @NotNull File dbPath, @Nullable byte[] passphrase) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
        if (dbPath.exists()) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = SQLiteDatabase.openDatabase((String)dbPath.getAbsolutePath(), (byte[])passphrase, null, (int)1, null, null);
                db.getVersion();
                bl = true;
            }
            catch (Exception e) {
                bl = false;
            }
            finally {
                SQLiteDatabase sQLiteDatabase = db;
                if (sQLiteDatabase != null) {
                    sQLiteDatabase.close();
                }
            }
            return bl;
        }
        return false;
    }

    public final void encrypt(@NotNull Context context, @NotNull File dbFile, @NotNull byte[] passphrase) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        File dbTemp = context.getDatabasePath("_temp.db");
        dbTemp.delete();
        Intrinsics.checkNotNull((Object)dbTemp);
        this.encryptTo(context, dbFile, dbTemp, passphrase);
        File dbBackup = context.getDatabasePath("_backup.db");
        if (dbFile.renameTo(dbBackup)) {
            if (!dbTemp.renameTo(dbFile)) {
                dbBackup.renameTo(dbFile);
                throw new IOException("Could not rename " + dbTemp + " to " + dbFile);
            }
        } else {
            dbTemp.delete();
            throw new IOException("Could not rename " + dbFile + " to " + dbBackup);
        }
        dbBackup.delete();
    }

    private final void encryptTo(Context context, File originalFile, File targetFile, byte[] passphrase) {
        if (!originalFile.exists()) {
            throw new FileNotFoundException(originalFile.getAbsolutePath() + " not found");
        }
        SQLiteDatabase originalDb = SQLiteDatabase.openDatabase((String)originalFile.getAbsolutePath(), (String)"", null, (int)0, null);
        int version = originalDb.getVersion();
        originalDb.close();
        SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((String)targetFile.getAbsolutePath(), (byte[])passphrase, null, null);
        SQLiteStatement sQLiteStatement = db.compileStatement("ATTACH DATABASE ? AS plaintext KEY ''");
        Intrinsics.checkNotNullExpressionValue((Object)sQLiteStatement, (String)"compileStatement(...)");
        SQLiteStatement st = sQLiteStatement;
        st.bindString(1, originalFile.getAbsolutePath());
        st.execute();
        db.rawExecSQL("SELECT sqlcipher_export('main', 'plaintext')", new Object[0]);
        db.rawExecSQL("DETACH DATABASE plaintext", new Object[0]);
        db.setVersion(version);
        st.close();
        db.close();
    }

    private final void decryptTo(Context context, File originalFile, File targetFile, byte[] passphrase) throws IOException {
        if (!originalFile.exists()) {
            throw new FileNotFoundException(originalFile.getAbsolutePath() + " not found");
        }
        SQLiteDatabase originalDb = SQLiteDatabase.openDatabase((String)originalFile.getAbsolutePath(), (byte[])passphrase, null, (int)0, null, null);
        SQLiteDatabase.openOrCreateDatabase((String)targetFile.getAbsolutePath(), (String)"", null, null).close();
        SQLiteStatement sQLiteStatement = originalDb.compileStatement("ATTACH DATABASE ? AS plaintext KEY ''");
        Intrinsics.checkNotNullExpressionValue((Object)sQLiteStatement, (String)"compileStatement(...)");
        SQLiteStatement st = sQLiteStatement;
        st.bindString(1, targetFile.getAbsolutePath());
        st.execute();
        originalDb.rawExecSQL("SELECT sqlcipher_export('plaintext')", new Object[0]);
        originalDb.rawExecSQL("DETACH DATABASE plaintext", new Object[0]);
        int version = originalDb.getVersion();
        st.close();
        originalDb.close();
        SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((String)targetFile.getAbsolutePath(), (String)"", null, null);
        db.setVersion(version);
        db.close();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/amity/socialcloud/sdk/infra/db/DBEncryptionUtils$State;", "", "<init>", "(Ljava/lang/String;I)V", "DOES_NOT_EXIST", "UNENCRYPTED", "ENCRYPTED", "amity-sdk_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State DOES_NOT_EXIST = new State();
        public static final /* enum */ State UNENCRYPTED = new State();
        public static final /* enum */ State ENCRYPTED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.DOES_NOT_EXIST, State.UNENCRYPTED, State.ENCRYPTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

