/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.core.domain.reaction.SyncLiveReactionsUseCase;
import com.amity.socialcloud.sdk.core.domain.reaction.SyncRoomReactionsUseCase;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.NetworkConnectionEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.NetworkConnectionEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 )2\u00020\u0001:\u0003)*+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000eJ\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "isActive", "", "buffer", "", "Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$ReactionDomainId;", "", "Lcom/amity/socialcloud/sdk/model/core/reaction/live/AmityLiveReaction;", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "isSyncing", "syncLiveReactions", "sendLiveReactions", "domainId", "reactions", "", "getReactionsToSync", "clearBuffer", "", "startReactionsSync", "stopReactionsSync", "createReaction", "liveReaction", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "Companion", "ReactionDomainId", "ReactionDomainType", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nLiveReactionSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveReactionSyncEngine.kt\ncom/amity/socialcloud/sdk/core/LiveReactionSyncEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,185:1\n1#2:186\n536#3:187\n521#3,6:188\n126#4:194\n153#4,3:195\n*S KotlinDebug\n*F\n+ 1 LiveReactionSyncEngine.kt\ncom/amity/socialcloud/sdk/core/LiveReactionSyncEngine\n*L\n115#1:187\n115#1:188,6\n118#1:194\n118#1:195,3\n*E\n"})
public final class LiveReactionSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isActive;
    @NotNull
    private final Map<ReactionDomainId, List<AmityLiveReaction>> buffer;
    @NotNull
    private final Completable timer;
    @NotNull
    private final CompositeDisposable disposable;
    private boolean isSyncing;
    private static final long SYNC_INTERVAL_MS = 1000L;
    private static final int BUFFER_MAX_SIZE = 100;

    public LiveReactionSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.buffer = new LinkedHashMap();
        Completable completable = Flowable.interval((long)SYNC_INTERVAL_MS, (TimeUnit)TimeUnit.MILLISECONDS).flatMapCompletable(new Function(this){
            final /* synthetic */ LiveReactionSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)LiveReactionSyncEngine.access$syncLiveReactions(this.this$0).onErrorComplete();
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        this.timer = completable;
        this.disposable = new CompositeDisposable();
        if (Intrinsics.areEqual(sessionStateEventBus.getCurrentEvent(), (Object)SessionState.Established.INSTANCE)) {
            this.startReactionsSync();
        }
        Disposable disposable = NetworkConnectionEventBus.INSTANCE.observe().doOnNext(new Consumer(){

            public final void accept(NetworkConnectionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof NetworkConnectionEvent.Connected) {
                    this.startReactionsSync();
                } else {
                    this.stopReactionsSync();
                }
            }
        }).subscribeOn(Schedulers.io()).subscribe();
        CompositeDisposable compositeDisposable = this.disposable;
        Disposable p0 = disposable;
        boolean bl = false;
        compositeDisposable.add(p0);
    }

    /*
     * Unable to fully structure code
     */
    private final Completable syncLiveReactions() {
        block8: {
            block6: {
                block7: {
                    if (!this.buffer.isEmpty() && this.isActive && !this.isSyncing) break block7;
                    var1_1 = Completable.complete();
                    Intrinsics.checkNotNull((Object)var1_1);
                    v0 = var1_1;
                    break block8;
                }
                this.isSyncing = true;
                var4_3 = this.buffer.keySet();
                for (T var6_5 : var4_3) {
                    it = (ReactionDomainId)var6_5;
                    $i$a$-find-LiveReactionSyncEngine$syncLiveReactions$domainId$1 = false;
                    if (this.buffer.get(it) == null) ** GOTO lbl-1000
                    v1 = this.buffer.get(it);
                    Intrinsics.checkNotNull(v1);
                    if (((Collection)v1).isEmpty() == false) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    v3 = var6_5;
                    break block6;
                }
                v3 = null;
            }
            v4 = v3;
            if (v4 == null) {
                v5 = Completable.complete();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"complete(...)");
                return v5;
            }
            domainId = v4;
            reactions = this.getReactionsToSync(domainId);
            if (((Collection)reactions).isEmpty() == false) {
                v0 = this.sendLiveReactions(domainId, reactions);
            } else {
                this.isSyncing = false;
                var3_9 = Completable.complete();
                Intrinsics.checkNotNull((Object)var3_9);
                v0 = var3_9;
            }
        }
        return v0;
    }

    private final Completable sendLiveReactions(ReactionDomainId domainId, List<AmityLiveReaction> reactions) {
        this.clearBuffer(domainId);
        return switch (WhenMappings.$EnumSwitchMapping$0[domainId.getType().ordinal()]) {
            case 1 -> {
                Completable var3_3 = new SyncLiveReactionsUseCase().execute(domainId.getId(), reactions).doOnComplete(() -> LiveReactionSyncEngine.sendLiveReactions$lambda$1(this)).doOnError(new Consumer(this){
                    final /* synthetic */ LiveReactionSyncEngine this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void accept(Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LiveReactionSyncEngine.access$setSyncing$p(this.this$0, false);
                    }
                });
                Intrinsics.checkNotNull((Object)var3_3);
                yield var3_3;
            }
            case 2 -> {
                Completable var3_4 = new SyncRoomReactionsUseCase().execute(domainId.getId(), reactions).doOnComplete(() -> LiveReactionSyncEngine.sendLiveReactions$lambda$2(this)).doOnError(new Consumer(this){
                    final /* synthetic */ LiveReactionSyncEngine this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void accept(Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LiveReactionSyncEngine.access$setSyncing$p(this.this$0, false);
                    }
                });
                Intrinsics.checkNotNull((Object)var3_4);
                yield var3_4;
            }
            default -> {
                Completable var3_5 = Completable.complete();
                Intrinsics.checkNotNull((Object)var3_5);
                yield var3_5;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AmityLiveReaction> getReactionsToSync(ReactionDomainId domainId) {
        List list;
        Map<ReactionDomainId, List<AmityLiveReaction>> map = this.buffer;
        synchronized (map) {
            boolean bl = false;
            List list2 = this.buffer.get(domainId);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void clearBuffer(ReactionDomainId domainId) {
        Map<ReactionDomainId, List<AmityLiveReaction>> map = this.buffer;
        synchronized (map) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            boolean bl = false;
            this.buffer.remove(domainId);
            Map<ReactionDomainId, List<AmityLiveReaction>> map2 = this.buffer;
            boolean $i$f$filter = false;
            void var6_8 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!(it.getValue() == null || ((List)it.getValue()).isEmpty())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl3 = false;
                object.add(this.buffer.remove(it.getKey()));
            }
            List list = (List)destination$iv$iv;
        }
    }

    private final void startReactionsSync() {
        this.isActive = true;
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    private final void stopReactionsSync() {
        this.isActive = false;
        if (this.disposable.size() > 0) {
            this.disposable.clear();
        }
        this.isSyncing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createReaction(@NotNull ReactionDomainId domainId, @NotNull AmityLiveReaction liveReaction) {
        Intrinsics.checkNotNullParameter((Object)domainId, (String)"domainId");
        Intrinsics.checkNotNullParameter((Object)liveReaction, (String)"liveReaction");
        Map<ReactionDomainId, List<AmityLiveReaction>> map = this.buffer;
        synchronized (map) {
            boolean bl = false;
            if (!this.buffer.containsKey(domainId)) {
                this.buffer.put(domainId, new ArrayList());
            }
            List<AmityLiveReaction> list = this.buffer.get(domainId);
            Boolean bl2 = list != null ? Boolean.valueOf(list.add(liveReaction)) : null;
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.startReactionsSync();
        } else {
            this.stopReactionsSync();
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.startReactionsSync();
    }

    @Override
    public void destroy() {
        this.stopReactionsSync();
    }

    @Override
    public void handleTokenExpire() {
        this.stopReactionsSync();
    }

    private static final void sendLiveReactions$lambda$1(LiveReactionSyncEngine this$0) {
        this$0.isSyncing = false;
    }

    private static final void sendLiveReactions$lambda$2(LiveReactionSyncEngine this$0) {
        this$0.isSyncing = false;
    }

    public static final /* synthetic */ void access$setSyncing$p(LiveReactionSyncEngine $this, boolean bl) {
        $this.isSyncing = bl;
    }

    public static final /* synthetic */ Completable access$syncLiveReactions(LiveReactionSyncEngine $this) {
        return $this.syncLiveReactions();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$Companion;", "", "<init>", "()V", "SYNC_INTERVAL_MS", "", "getSYNC_INTERVAL_MS", "()J", "BUFFER_MAX_SIZE", "", "getBUFFER_MAX_SIZE", "()I", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getSYNC_INTERVAL_MS() {
            return SYNC_INTERVAL_MS;
        }

        public final int getBUFFER_MAX_SIZE() {
            return BUFFER_MAX_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$ReactionDomainId;", "", "id", "", "type", "Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$ReactionDomainType;", "<init>", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$ReactionDomainType;)V", "getId", "()Ljava/lang/String;", "getType", "()Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$ReactionDomainType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "amity-sdk_release"})
    public static final class ReactionDomainId {
        @NotNull
        private final String id;
        @NotNull
        private final ReactionDomainType type;

        public ReactionDomainId(@NotNull String id, @NotNull ReactionDomainType type2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            this.id = id;
            this.type = type2;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final ReactionDomainType getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final ReactionDomainType component2() {
            return this.type;
        }

        @NotNull
        public final ReactionDomainId copy(@NotNull String id, @NotNull ReactionDomainType type2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            return new ReactionDomainId(id, type2);
        }

        public static /* synthetic */ ReactionDomainId copy$default(ReactionDomainId reactionDomainId, String string, ReactionDomainType reactionDomainType, int n, Object object) {
            if ((n & 1) != 0) {
                string = reactionDomainId.id;
            }
            if ((n & 2) != 0) {
                reactionDomainType = reactionDomainId.type;
            }
            return reactionDomainId.copy(string, reactionDomainType);
        }

        @NotNull
        public String toString() {
            return "ReactionDomainId(id=" + this.id + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReactionDomainId)) {
                return false;
            }
            ReactionDomainId reactionDomainId = (ReactionDomainId)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)reactionDomainId.id)) {
                return false;
            }
            return this.type == reactionDomainId.type;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$ReactionDomainType;", "", "<init>", "(Ljava/lang/String;I)V", "LIVESTREAM", "ROOM", "amity-sdk_release"})
    public static final class ReactionDomainType
    extends Enum<ReactionDomainType> {
        public static final /* enum */ ReactionDomainType LIVESTREAM = new ReactionDomainType();
        public static final /* enum */ ReactionDomainType ROOM = new ReactionDomainType();
        private static final /* synthetic */ ReactionDomainType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReactionDomainType[] values() {
            return (ReactionDomainType[])$VALUES.clone();
        }

        public static ReactionDomainType valueOf(String value) {
            return Enum.valueOf(ReactionDomainType.class, value);
        }

        @NotNull
        public static EnumEntries<ReactionDomainType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = reactionDomainTypeArray = new ReactionDomainType[]{ReactionDomainType.LIVESTREAM, ReactionDomainType.ROOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReactionDomainType.values().length];
            try {
                nArray[ReactionDomainType.LIVESTREAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReactionDomainType.ROOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

