/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.comment;

import com.amity.socialcloud.sdk.api.core.ExperimentalAmityApi;
import com.amity.socialcloud.sdk.api.social.comment.create.AmityCommentCreationTarget;
import com.amity.socialcloud.sdk.api.social.comment.latest.AmityLatestCommentQueryType;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentQueryType;
import com.amity.socialcloud.sdk.api.social.comment.update.AmityAttachmentCommentUpdate;
import com.amity.socialcloud.sdk.model.core.flag.AmityContentFlagReason;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.domain.comment.getbyids.CommentGetByIdsUseCase;
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest;
import com.ekoapp.ekosdk.internal.usecase.comment.DeleteCommentUseCase;
import com.ekoapp.ekosdk.internal.usecase.comment.FlagCommentUseCase;
import com.ekoapp.ekosdk.internal.usecase.comment.ObserveSingleCommentUseCase;
import com.ekoapp.ekosdk.internal.usecase.comment.UnFlagCommentUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u001c"}, d2={"Lcom/amity/socialcloud/sdk/api/social/comment/AmityCommentRepository;", "", "<init>", "()V", "getComment", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "commentId", "", "getCommentByIds", "", "commentIds", "", "getComments", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentQueryType;", "createComment", "Lcom/amity/socialcloud/sdk/api/social/comment/create/AmityCommentCreationTarget;", "editComment", "Lcom/amity/socialcloud/sdk/api/social/comment/update/AmityAttachmentCommentUpdate$Builder;", "softDeleteComment", "Lio/reactivex/rxjava3/core/Completable;", "hardDeleteComment", "getLatestComment", "Lcom/amity/socialcloud/sdk/api/social/comment/latest/AmityLatestCommentQueryType;", "flagComment", "reason", "Lcom/amity/socialcloud/sdk/model/core/flag/AmityContentFlagReason;", "unflagComment", "amity-sdk_release"})
public final class AmityCommentRepository {
    @ExperimentalAmityApi
    @NotNull
    public final Flowable<AmityComment> getComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new ObserveSingleCommentUseCase().execute(commentId);
    }

    @NotNull
    public final Flowable<List<AmityComment>> getCommentByIds(@NotNull Set<String> commentIds) {
        Intrinsics.checkNotNullParameter(commentIds, (String)"commentIds");
        return new CommentGetByIdsUseCase().execute(commentIds);
    }

    @NotNull
    public final AmityCommentQueryType getComments() {
        return new AmityCommentQueryType();
    }

    @NotNull
    public final AmityCommentCreationTarget createComment() {
        return new AmityCommentCreationTarget(null, 1, null);
    }

    @NotNull
    public final AmityAttachmentCommentUpdate.Builder editComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new AmityAttachmentCommentUpdate.Builder(commentId);
    }

    @NotNull
    public final Completable softDeleteComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new DeleteCommentUseCase().execute(commentId, false);
    }

    @NotNull
    public final Completable hardDeleteComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new DeleteCommentUseCase().execute(commentId, true);
    }

    @NotNull
    public final AmityLatestCommentQueryType getLatestComment() {
        return new AmityLatestCommentQueryType();
    }

    @Deprecated(message="This function is deprecated, please use flagComment(commentId: String, reason: AmityContentFlagReason) instead", replaceWith=@ReplaceWith(expression="flagComment(commentId: String, reason: AmityContentFlagReason)", imports={"com.amity.socialcloud.sdk.api.social.comment.AmityCommentRepository"}))
    @NotNull
    public final Completable flagComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return this.flagComment(commentId, new AmityContentFlagReason.Others(null, 1, null));
    }

    @NotNull
    public final Completable flagComment(@NotNull String commentId, @NotNull AmityContentFlagReason reason) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        FlagContentRequest request = reason instanceof AmityContentFlagReason.Others ? new FlagContentRequest(reason.getReason(), ((AmityContentFlagReason.Others)reason).getDetails()) : new FlagContentRequest(reason.getReason(), null, 2, null);
        return new FlagCommentUseCase().execute(commentId, request);
    }

    @NotNull
    public final Completable unflagComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new UnFlagCommentUseCase().execute(commentId);
    }
}

