package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetGlobalFeedV5PagingDataUseCase {

    fun execute(
        dataTypes: List<AmityPost.DataType>,
        includeMixedStructure: Boolean
    ): Flowable<PagingData<AmityPost>> {
        return PostRepository().getCustomPostRankingPagingData(
            dataTypes = dataTypes,
            includeMixedStructure = includeMixedStructure
        )
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                    PostComposerUseCase().execute(post)
                }
            }
    }

}