package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import io.reactivex.rxjava3.core.Flowable

internal class CommunityLiveRoomPostQueryUseCase {

    fun execute(communityIds: List<String>): Flowable<List<AmityPost>> {
        val normalizedIds = communityIds
            .map { it.trim() }
            .filter { it.isNotEmpty() }
            .distinct()

        if (normalizedIds.isEmpty()) {
            return Flowable.just(emptyList())
        }

        val liveRoomPostQueryUseCase = LiveRoomPostQueryUseCase()
        return liveRoomPostQueryUseCase.execute(
            targetType = TARGET_TYPE_COMMUNITY,
            targetIds = normalizedIds
        )
    }

    private companion object {
        private const val TARGET_TYPE_COMMUNITY = "community"
    }
}
