package com.amity.socialcloud.sdk.social.domain.event.update

import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventType
import com.amity.socialcloud.sdk.social.data.event.EventRepository
import com.amity.socialcloud.sdk.social.domain.event.EventComposerUseCase
import io.reactivex.rxjava3.core.Single
import org.joda.time.DateTime

internal class EventUpdateUseCase {

    fun execute(
        eventId: String,
        title: String?,
        description: String?,
        type: AmityEventType?,
        isInviteOnly: Boolean?,
        startTime: DateTime?,
        endTime: DateTime?,
        location: String?,
        externalUrl: String?,
        coverImageFileId: String?,
        tags: AmityTags?,
        timezone: String?
    ): Single<AmityEvent> {
        return EventRepository()
            .updateEvent(
                eventId = eventId,
                title = title,
                description = description,
                type = type,
                isInviteOnly = isInviteOnly,
                startTime = startTime,
                endTime = endTime,
                location = location,
                externalUrl = externalUrl,
                coverImageFileId = coverImageFileId,
                tags = tags,
                timezone = timezone
            )
            .map { EventComposerUseCase().execute(it) }
    }
}
