package com.amity.socialcloud.sdk.model.core.reaction.live

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

@Parcelize
data class AmityLiveReaction internal constructor(
    private val referenceType: String,
    private val referenceId: String,
    private val reactionName: String,
    private val userId: String,
    private val occurredAt : DateTime,
) : Parcelable {

    fun getReferenceType(): String {
        return referenceType
    }

    fun getReferenceId(): String {
        return referenceId
    }

    fun getCreatorId(): String {
        return userId
    }

    fun getReactionName(): String {
        return reactionName
    }

    fun getOccurredAt(): DateTime {
        return occurredAt
    }
}