package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.data.room.RoomListQueryPersister
import com.amity.socialcloud.sdk.core.data.room.RoomLocalDataStore
import com.amity.socialcloud.sdk.dto.video.RoomListDto
import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.data.post.PostEventPersister
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class RoomEventListener: MqttEventListener<RoomListDto>() {

    override val type: KClass<RoomListDto>
        get() = RoomListDto::class

    override fun processEvent(dto: RoomListDto) {
        RoomListQueryPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: RoomListDto): Boolean {
        var shouldProcessEvent = false
        val roomId = dto.rooms?.first()?.roomId
        roomId?.let {
            shouldProcessEvent = RoomLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}