package com.amity.socialcloud.sdk.entity.core.notificationtray

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayActor
import com.google.gson.GsonBuilder
import com.google.gson.InstanceCreator
import com.google.gson.reflect.TypeToken
import org.joda.time.Chronology
import org.joda.time.chrono.ISOChronology
import java.lang.reflect.Type

class NotificationTrayActorIdMapTypeConverter {
    @TypeConverter
    fun fromString(json: String?): List<AmityNotificationTrayActor> {
        if (json.isNullOrBlank()) return emptyList()
        val trimmedJson = json.trim()
        if (!trimmedJson.startsWith("[")) return emptyList()

        return try {
            val gson = GsonBuilder()
                .registerTypeAdapter(Chronology::class.java, ChronologyInstanceCreator())
                .create()
            val type = object : TypeToken<List<AmityNotificationTrayActor>>() {}.type
            gson.fromJson<List<AmityNotificationTrayActor>>(trimmedJson, type) ?: emptyList()
        } catch (e: Exception) {
            e.printStackTrace()
            emptyList()
        }
    }

    @TypeConverter
    fun toString(actors: List<AmityNotificationTrayActor>?): String? {
        if (actors.isNullOrEmpty()) return null
        return GsonBuilder()
            .registerTypeAdapter(Chronology::class.java, ChronologyInstanceCreator())
            .create()
            .toJson(actors)
    }

    class ChronologyInstanceCreator : InstanceCreator<Chronology> {
        override fun createInstance(type: Type?): Chronology {
            return ISOChronology.getInstance()
        }
    }
}

