package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.entity.video.room.RoomModerationEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable

internal class RoomModerationLocalDataStore {

    fun saveModerations(moderations: List<RoomModerationEntity>): Completable {
        return Completable.fromAction {
            if (moderations.isNotEmpty()) {
                UserDatabase.get().roomModerationDao().save(moderations)
            }
        }
    }

    fun getModeration(moderationId: String): RoomModerationEntity? {
        return UserDatabase.get().roomModerationDao().getByIdNow(moderationId)
    }

    fun getModerationByRoomId(roomId: String): RoomModerationEntity? {
        return UserDatabase.get().roomModerationDao().getByRoomIdNow(roomId)
    }
}
