package com.amity.socialcloud.sdk.api.chat.message.create

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject

class AmityTextMessageCreator private constructor(
    subChannelId: String,
    parentId: String?,
    metadata: JsonObject?,
    tags: AmityTags,
    mentionees: List<AmityMentioneeTarget>,
    private val text: String
) : AmityMessageCreator(subChannelId, parentId, metadata, tags, mentionees) {

    override fun getData(): JsonObject {
        val data = JsonObject()
        data.addProperty(getDataType().apiKey, text)
        return data
    }

    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.TEXT
    }

    class Builder internal constructor(){
        private lateinit var subChannelId: String
        private var parentId: String? = null
        private lateinit var text: String
        private var metadata: JsonObject? = null
        private var tags: AmityTags = AmityTags()
        private var mentionees: MutableList<AmityMentioneeTarget> = mutableListOf()

        internal fun subChannelId(subChannelId: String): Builder {
            this.subChannelId = subChannelId
            return this
        }

        fun parentId(parentId: String?): Builder {
            this.parentId = parentId
            return this
        }

        internal fun text(text: String): Builder {
            this.text = text
            return this
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun tags(tags: AmityTags): Builder {
            this.tags = tags
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            mentionees.add(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun mentionChannel(): Builder {
            mentionees.add(AmityMentioneeTarget(AmityMentionType.CHANNEL.apiKey))
            return this
        }

        fun build(): AmityTextMessageCreator {
            return AmityTextMessageCreator(subChannelId, parentId, metadata, tags, mentionees, text)
        }
    }

}