package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "user_follow", primaryKeys = ["sourceUserId", "targetUserId"])
data class EkoUserFollowStatusEntity(private var id: String = ObjectId.get().toHexString(),
                                              var sourceUserId: String = ObjectId.get().toHexString(),
                                              var targetUserId: String = ObjectId.get().toHexString(),
                                              var status: String? = null) : EkoObject() {

    companion object {
        const val NONCE: Int = 11
    }

    override fun getId(): String {
        return id
    }

    fun setId(id: String) {
        this.id = id
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? EkoUserFollowStatusEntity)?.let { userFollow ->
            (Objects.equal(id, userFollow.id))
                    && (Objects.equal(sourceUserId, userFollow.sourceUserId))
                    && (Objects.equal(targetUserId, userFollow.targetUserId))
                    && (Objects.equal(status, userFollow.status))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(id, sourceUserId, targetUserId, status)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("id", id)
            add("sourceUserId", sourceUserId)
            add("targetUserId", targetUserId)
            add("status", status)
        }
        return super.internalToString(toStringHelper)
    }
}