package com.amity.socialcloud.sdk.social.data.story.reaction

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.dto.social.story.StoryDto
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity


internal class StoryReactionEntityMapper : EntityMapper<StoryDto, EkoReactionEntity>() {

    override fun map(list: List<StoryDto>): List<EkoReactionEntity> {
        val reactions = mutableListOf<EkoReactionEntity>()
        list.forEach {
            val reactionNames = it.myReactions?.map { reactionName ->
                ReactionRepository().createMyReaction(
                    AmityReactionReferenceType.STORY,
                    it.storyId ?: "",
                    reactionName
                )
            }
            reactionNames?.let {
                reactions.addAll(it)
            }
        }
        return reactions
    }
}