package com.amity.socialcloud.sdk.api.core.presence

import android.util.Log
import com.amity.socialcloud.sdk.core.presence.PresenceSyncEngine
import com.ekoapp.ekosdk.internal.usecase.presence.DisablePresenceUseCase
import com.ekoapp.ekosdk.internal.usecase.presence.EnablePresenceUseCase
import com.ekoapp.ekosdk.internal.usecase.presence.GetPresenceUserSettingUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

class AmityPresenceService internal constructor(
    private val presenceSyncEngine: PresenceSyncEngine?
) {

    /* begin_public_function
      id: client.presence.enable
    */
    fun enable(): Completable {
        return EnablePresenceUseCase().execute()
    }
    /* end_public_function */

    /* begin_public_function
     id: client.presence.disable
   */
    fun disable(): Completable {
        presenceSyncEngine?.stopHeartbeat()
        return DisablePresenceUseCase().execute()
    }
    /* end_public_function */

    /* begin_public_function
     id: client.presence.is_enabled
   */
    fun isEnabled(): Single<Boolean> {
        return GetPresenceUserSettingUseCase().execute()
    }
    /* end_public_function */

    /* begin_public_function
     id: client.presence.start_heartbeat
   */
    fun startHeartbeat(): Completable {
        return presenceSyncEngine?.startHeartbeat() ?: Completable.never()
    }
    /* end_public_function */

    /* begin_public_function
     id: client.presence.stop_heartbeat
   */
    fun stopHeartbeat() {
        presenceSyncEngine?.stopHeartbeat()
    }
    /* end_public_function */

    internal fun startRoomHeartbeat(roomId: String): Completable {
        return presenceSyncEngine?.startRoomHeartbeat(roomId = roomId) ?: Completable.never()
    }

    internal fun stopRoomHeartbeat() {
        presenceSyncEngine?.stopRoomHeartbeat()
    }
}