/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.ChannelReadReceiptEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.ChannelReadReceiptDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class ChannelReadReceiptDao_Impl
extends ChannelReadReceiptDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<ChannelReadReceiptEntity> __insertAdapterOfChannelReadReceiptEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<ChannelReadReceiptEntity> __deleteAdapterOfChannelReadReceiptEntity;
    private final EntityDeleteOrUpdateAdapter<ChannelReadReceiptEntity> __updateAdapterOfChannelReadReceiptEntity;

    public ChannelReadReceiptDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfChannelReadReceiptEntity = new EntityInsertAdapter<ChannelReadReceiptEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `channel_read_receipt` (`channelId`,`latestSegment`,`latestSyncSegment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelReadReceiptEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                statement.bindLong(2, (long)entity.getLatestSegment());
                statement.bindLong(3, (long)entity.getLatestSyncSegment());
                String _tmp = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfChannelReadReceiptEntity = new EntityDeleteOrUpdateAdapter<ChannelReadReceiptEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `channel_read_receipt` WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelReadReceiptEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
            }
        };
        this.__updateAdapterOfChannelReadReceiptEntity = new EntityDeleteOrUpdateAdapter<ChannelReadReceiptEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `channel_read_receipt` SET `channelId` = ?,`latestSegment` = ?,`latestSyncSegment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelReadReceiptEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                statement.bindLong(2, (long)entity.getLatestSegment());
                statement.bindLong(3, (long)entity.getLatestSyncSegment());
                String _tmp = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = ChannelReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(ChannelReadReceiptEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelReadReceiptEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends ChannelReadReceiptEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelReadReceiptEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(ChannelReadReceiptEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelReadReceiptEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends ChannelReadReceiptEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelReadReceiptEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(ChannelReadReceiptEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfChannelReadReceiptEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(ChannelReadReceiptEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelReadReceiptDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends ChannelReadReceiptEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelReadReceiptDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(ChannelReadReceiptEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChannelReadReceiptDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public ChannelReadReceiptEntity getByIdNow(String id) {
        String _sql = "SELECT * from channel_read_receipt where channelId = ? LIMIT 1";
        return (ChannelReadReceiptEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_read_receipt where channelId = ? LIMIT 1");){
                ChannelReadReceiptEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfLatestSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSegment");
                int _columnIndexOfLatestSyncSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSyncSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelReadReceiptEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpLatestSegment = (int)_stmt.getLong(_columnIndexOfLatestSegment);
                    _result.setLatestSegment(_tmpLatestSegment);
                    int _tmpLatestSyncSegment = (int)_stmt.getLong(_columnIndexOfLatestSyncSegment);
                    _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelReadReceiptEntity channelReadReceiptEntity = _result;
                return channelReadReceiptEntity;
            }
        });
    }

    @Override
    public Flowable<ChannelReadReceiptEntity> getById(String channelId) {
        String _sql = "SELECT * from channel_read_receipt where channelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_read_receipt"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_read_receipt where channelId = ? LIMIT 1");){
                ChannelReadReceiptEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfLatestSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSegment");
                int _columnIndexOfLatestSyncSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSyncSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelReadReceiptEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpLatestSegment = (int)_stmt.getLong(_columnIndexOfLatestSegment);
                    _result.setLatestSegment(_tmpLatestSegment);
                    int _tmpLatestSyncSegment = (int)_stmt.getLong(_columnIndexOfLatestSyncSegment);
                    _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelReadReceiptEntity channelReadReceiptEntity = _result;
                return channelReadReceiptEntity;
            }
        });
    }

    @Override
    public List<ChannelReadReceiptEntity> getUnsyncReadReceipts() {
        String _sql = "SELECT * from channel_read_receipt where latestSyncSegment < latestSegment";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_read_receipt where latestSyncSegment < latestSegment");){
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfLatestSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSegment");
                int _columnIndexOfLatestSyncSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestSyncSegment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<ChannelReadReceiptEntity> _result = new ArrayList<ChannelReadReceiptEntity>();
                while (_stmt.step()) {
                    ChannelReadReceiptEntity _item = new ChannelReadReceiptEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    int _tmpLatestSegment = (int)_stmt.getLong(_columnIndexOfLatestSegment);
                    _item.setLatestSegment(_tmpLatestSegment);
                    int _tmpLatestSyncSegment = (int)_stmt.getLong(_columnIndexOfLatestSyncSegment);
                    _item.setLatestSyncSegment(_tmpLatestSyncSegment);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<ChannelReadReceiptEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from channel_read_receipt";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_read_receipt");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteByChannelId(String channelId) {
        String _sql = "DELETE from channel_read_receipt where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_read_receipt where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateLatestSegment(String channelId, int segment) {
        String _sql = "UPDATE channel_read_receipt set latestSegment = ? where channelId = ? and latestSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_read_receipt set latestSegment = ? where channelId = ? and latestSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)segment);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)segment);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateLatestSyncSegment(String channelId, int segment) {
        String _sql = "UPDATE channel_read_receipt set latestSyncSegment = ? where channelId = ? and latestSyncSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_read_receipt set latestSyncSegment = ? where channelId = ? and latestSyncSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)segment);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)segment);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

