/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.storytarget.composer;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget;
import com.amity.socialcloud.sdk.social.data.story.StoryRepository;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository;
import com.amity.socialcloud.sdk.social.domain.community.CommunityGetUseCase;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/storytarget/composer/StoryTargetComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "<init>", "()V", "execute", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryTarget;", "storyTarget", "addSyncingCount", "", "addFailedCount", "addTarget", "addHighestSeen", "getHighestSeen", "Lorg/joda/time/DateTime;", "addHasUnseen", "updateStoryTarget", "hasUnseen", "", "localSortingDate", "amity-sdk_release"})
public final class StoryTargetComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityStoryTarget execute(@NotNull AmityStoryTarget storyTarget) {
        Intrinsics.checkNotNullParameter((Object)storyTarget, (String)"storyTarget");
        this.addSyncingCount(storyTarget);
        this.addFailedCount(storyTarget);
        this.addTarget(storyTarget);
        this.addHighestSeen(storyTarget);
        this.addHasUnseen(storyTarget);
        return storyTarget;
    }

    private final void addSyncingCount(AmityStoryTarget storyTarget) {
        storyTarget.setSyncingStoriesCount$amity_sdk_release(new StoryRepository().getSyncingStoriesCount(storyTarget.getTargetType(), storyTarget.getTargetId()));
    }

    private final void addFailedCount(AmityStoryTarget storyTarget) {
        storyTarget.setFailedStoriesCount$amity_sdk_release(new StoryRepository().getFailedStoriesCount(storyTarget.getTargetType(), storyTarget.getTargetId()));
    }

    private final void addTarget(AmityStoryTarget storyTarget) {
        if (storyTarget instanceof AmityStoryTarget.COMMUNITY) {
            ((AmityStoryTarget.COMMUNITY)storyTarget).setCommunity$amity_sdk_release(new CommunityGetUseCase().execute(storyTarget.getTargetId()));
        }
    }

    private final void addHighestSeen(AmityStoryTarget storyTarget) {
        storyTarget.setHighestSeen$amity_sdk_release(this.getHighestSeen(storyTarget));
    }

    private final DateTime getHighestSeen(AmityStoryTarget storyTarget) {
        return storyTarget.getLocalLastStorySeenExpiresAt$amity_sdk_release() == null && storyTarget.getLastStorySeenExpiresAt$amity_sdk_release() == null ? null : (storyTarget.getLocalLastStorySeenExpiresAt$amity_sdk_release() == null ? storyTarget.getLastStorySeenExpiresAt$amity_sdk_release() : (storyTarget.getLastStorySeenExpiresAt$amity_sdk_release() == null ? storyTarget.getLocalLastStorySeenExpiresAt$amity_sdk_release() : (storyTarget.getLocalLastStorySeenExpiresAt$amity_sdk_release().isAfter((ReadableInstant)storyTarget.getLastStorySeenExpiresAt$amity_sdk_release()) ? storyTarget.getLocalLastStorySeenExpiresAt$amity_sdk_release() : storyTarget.getLastStorySeenExpiresAt$amity_sdk_release())));
    }

    /*
     * Unable to fully structure code
     */
    private final void addHasUnseen(AmityStoryTarget storyTarget) {
        block12: {
            block11: {
                now = DateTime.now();
                computedHasUnseen = false;
                localSortingDate = null;
                if (storyTarget.getSyncingStoriesCount$amity_sdk_release() + storyTarget.getFailedStoriesCount$amity_sdk_release() <= 0) break block11;
                v0 = storyTarget.getLocalLastStoryExpiresAt$amity_sdk_release();
                if (!(v0 != null ? v0.isAfter((ReadableInstant)now) : false)) ** GOTO lbl-1000
                v1 = storyTarget.getLocalLastStoryExpiresAt$amity_sdk_release();
                if (v1 != null) {
                    v2 = this.getHighestSeen(storyTarget);
                    if (v2 == null) {
                        v2 = now;
                    }
                    v3 = v1.isAfter((ReadableInstant)v2);
                } else {
                    v3 = false;
                }
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                computedHasUnseen = v4;
                localSortingDate = storyTarget.getLocalLastStoryExpiresAt$amity_sdk_release();
                break block12;
            }
            v5 = storyTarget.getLastStoryExpiresAt$amity_sdk_release();
            if (!(v5 != null ? v5.isAfter((ReadableInstant)now) : false)) ** GOTO lbl-1000
            v6 = storyTarget.getLastStoryExpiresAt$amity_sdk_release();
            if (v6 != null) {
                v7 = this.getHighestSeen(storyTarget);
                if (v7 == null) {
                    v7 = now;
                }
                v8 = v6.isAfter((ReadableInstant)v7);
            } else {
                v8 = false;
            }
            if (v8) {
                v9 = true;
            } else lbl-1000:
            // 2 sources

            {
                v9 = false;
            }
            computedHasUnseen = v9;
            localSortingDate = storyTarget.getLastStoryExpiresAt$amity_sdk_release();
        }
        if (storyTarget.getHasUnseen$amity_sdk_release() != computedHasUnseen || !Intrinsics.areEqual((Object)storyTarget.getLocalSortingDate$amity_sdk_release(), (Object)localSortingDate)) {
            storyTarget.setHasUnseen$amity_sdk_release(computedHasUnseen);
            storyTarget.setLocalSortingDate$amity_sdk_release(localSortingDate);
            this.updateStoryTarget(storyTarget, computedHasUnseen, localSortingDate);
        }
    }

    private final void updateStoryTarget(AmityStoryTarget storyTarget, boolean hasUnseen, DateTime localSortingDate) {
        new StoryTargetRepository().updateStoryTargetHasUnseen(storyTarget.getTargetType(), storyTarget.getTargetId(), hasUnseen, localSortingDate).subscribeOn(Schedulers.io()).onErrorComplete().subscribe();
    }
}

