package com.amity.socialcloud.sdk.model.social.community

enum class AmityCommunityType(val apiKey: String) {
    DEFAULT("default"),
    EVENT("event"),
    UNKNOWN("unknown");

    companion object {
        fun enumOf(value: String?): AmityCommunityType {
            return values().find { it.apiKey == value } ?: UNKNOWN
        }
    }
}
