package com.amity.socialcloud.sdk.api.social.event.query

import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus
import com.amity.socialcloud.sdk.model.social.event.AmityEventType

/**
 * Query options for event queries.
 */
data class AmityEventQueryOption(
    val originType: AmityEventOriginType? = null,
    val originId: String? = null,
    val userId: String? = null,
    val status: AmityEventStatus? = null,
    val type: AmityEventType? = null,
    val onlyAttendee: Boolean? = null,
    val sortBy: AmityEventSortOption = AmityEventSortOption.START_TIME,
    val orderBy: AmityEventOrderOption = AmityEventOrderOption.ASCENDING
)
