package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import io.reactivex.rxjava3.core.Flowable

internal class PostReactorUseCase {

    fun execute(
        targetType: AmityPost.TargetType,
        targetId: String,
        isDeleted: Boolean?,
        dataTypes: List<AmityPost.DataType>,
        includeMixedStructure: Boolean,
        dynamicQueryStreamKeyCreator: DynamicQueryStreamKeyCreator,
        nonce: Int = 0,
        feedType: AmityFeedType? = null
    ): Flowable<AmityPost> {
        return PostRepository().getLatestPost(
            targetType = targetType.apiKey,
            targetId = targetId,
            isDeleted = isDeleted,
            dataTypes = dataTypes,
            feedType = feedType,
            includeMixedStructure = includeMixedStructure,
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            nonce = nonce
        )
    }
}