package com.ekoapp.ekosdk.internal.keycreator

class RoomKeyCreator(
    private val statuses: List<String>,
    private val types: List<String>?,
    private val isDeleted: Boolean?,
    private val sortBy: String?
) : DynamicQueryStreamKeyCreator {

    override fun getFilterQuery(): String {
        val clauses = mutableListOf<String>()
        if (statuses.isNotEmpty()) clauses += "room.status IN (${statuses.toSqlArray()})"
        types?.takeIf { it.isNotEmpty() }?.let { clauses += "room.type IN (${it.toSqlArray()})" }
        isDeleted?.let { clauses += "room.isDeleted = ${if (it) 1 else 0}" } ?: clauses.add("room.isDeleted = 0")
        return clauses.joinToString(" and ")
    }

    override fun toMap(): Map<String, Any> {
        val map = mutableMapOf<String, Any>("statuses" to statuses)
        types?.let { map["types"] = it }
        isDeleted?.let { map["isDeleted"] = it }
        sortBy?.let { map["sortBy"] = it }
        return map
    }
}

