package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus
import com.amity.socialcloud.sdk.model.social.event.AmityEventType
import com.amity.socialcloud.sdk.social.data.event.paging.EventQueryKeyCreator
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface EventPagingDao : DynamicQueryStreamPagingDao<EventEntity> {

    @RawQuery(observedEntities = [EventEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EventEntity>

    fun getEventPagingSource(
        originType: AmityEventOriginType?,
        originId: String?,
        userId: String?,
        status: AmityEventStatus?,
        type: AmityEventType?,
        onlyAttendee: Boolean?,
        sortBy: com.amity.socialcloud.sdk.api.social.event.query.AmityEventSortOption,
        orderBy: com.amity.socialcloud.sdk.api.social.event.query.AmityEventOrderOption
    ): PagingSource<Int, EventEntity> {
        val order = when (orderBy) {
            com.amity.socialcloud.sdk.api.social.event.query.AmityEventOrderOption.ASCENDING -> AmityPagingDao.Order.ASC
            com.amity.socialcloud.sdk.api.social.event.query.AmityEventOrderOption.DESCENDING -> AmityPagingDao.Order.DESC
        }
        
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "event",
                primaryKeyColumnName = "eventId",
                nonce = AmityNonce.EVENT_QUERY,
                sortColumn = sortBy.value,
                order = order,
                dynamicQueryStreamKeyCreator = EventQueryKeyCreator(
                    originType = originType,
                    originId = originId,
                    userId = userId,
                    status = status,
                    type = type,
                    onlyAttendee = onlyAttendee,
                    sortBy = sortBy,
                    orderBy = orderBy
                )
            )
        )
    }
}
