package com.amity.socialcloud.sdk.video.domain.room

import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.video.domain.room.compose.RoomComposerUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class GetRoomByIdsUseCase {
    fun execute(roomIds: List<String>): List<AmityRoom> {
        var rooms: List<AmityRoom> = emptyList()
        Completable.fromAction {
            rooms = RoomRepository().getRoomsByIds(roomIds)
                    .map { RoomComposerUseCase().execute(it) }
        }
            .subscribeOn(Schedulers.io())
            .blockingAwait()
        return rooms
    }
}
