package com.amity.socialcloud.sdk.video.data.room

import com.amity.socialcloud.sdk.model.video.room.AmityRoomModeration
import com.amity.socialcloud.sdk.model.video.room.AmityRoomModerationLabel
import com.amity.socialcloud.sdk.entity.video.room.RoomModerationEntity
import com.google.gson.JsonArray
import com.google.gson.JsonElement

internal class RoomModerationModelMapper {
    fun map(entity: RoomModerationEntity): AmityRoomModeration = AmityRoomModeration(
        moderationId = entity.moderationId,
        roomId = entity.roomId,
        flagLabels = parseLabels(entity.flagLabels),
        terminateLabels = parseLabels(entity.terminateLabels),
        createdAt = entity.createdAt,
        updatedAt = entity.updatedAt
    )

    private fun parseLabels(array: JsonArray?): List<AmityRoomModerationLabel> {
        if (array == null) return emptyList()
        val list = mutableListOf<AmityRoomModerationLabel>()
        for (elem: JsonElement in array) {
            val obj = elem.asJsonObject
            list += AmityRoomModerationLabel(
                category = obj.get("category")?.asString ?: "",
                detectedAt = obj.get("detectedAt")?.asLong?.let { org.joda.time.DateTime(it) }
            )
        }
        return list
    }
}

