package com.amity.socialcloud.sdk.social.domain.event

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponse
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponseStatus
import com.amity.socialcloud.sdk.social.data.event.AmityEventResponseRepository
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class EventRSVPQueryUseCase {

    fun execute(
        eventId: String,
        status: AmityEventResponseStatus?
    ): Flowable<PagingData<AmityEventResponse>> {
        return AmityEventResponseRepository().getEventResponsePagingData(
            eventId = eventId,
            status = status
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { response ->
                // Response is already composed in EventResponseModelMapper
                response
            }
        }
    }
}
