package com.amity.socialcloud.sdk.social.domain.event

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponse
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.CommunityModelMapper
import com.amity.socialcloud.sdk.social.data.event.EventEntityMapper
import com.amity.socialcloud.sdk.social.data.event.EventModelMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto
import com.ekoapp.ekosdk.internal.api.dto.EventDto
import io.reactivex.rxjava3.core.Completable

internal class EventComposerUseCase : ComposerUseCase() {

    fun execute(event: AmityEvent): AmityEvent {
        addCreator(event)
        addCoverImage(event)
        addTargetCommunity(event)
        return event
    }

    private fun addCreator(event: AmityEvent) {
        event.creator = UserGetUseCase().execute(event.getUserId())
    }
    
    private fun addCoverImage(event: AmityEvent) {
        event.getCoverImageFileId()?.let { fileId ->
            event.coverImage = ImageGetUseCase().execute(fileId)
        }
    }
    
    private fun addTargetCommunity(event: AmityEvent) {
        if (event.getOriginType() == AmityEventOriginType.COMMUNITY) {
            val communityEntity = CommunityLocalDataStore().getCommunityById(event.getOriginId())
            communityEntity?.let {
                event.targetCommunity = CommunityModelMapper().map(it)
            }
        }
    }
    
    fun composeRSVP(
        rsvp: AmityEventResponse,
        events: List<EventDto>?,
        users: List<EkoUserDto>?,
        files: List<EkoFileDto>?
    ): Completable {
        return Completable.fromAction {
            // Add linked event
            events?.find { it.eventId == rsvp.getEventId() }?.let { eventDto ->
                val eventEntity = EventEntityMapper().map(listOf(eventDto)).firstOrNull()
                eventEntity?.let {
                    val event = EventModelMapper().map(it)
                    execute(event) // Compose the event with its linked objects
                    rsvp.event = event
                }
            }
            
            // Add linked user
            rsvp.user = UserGetUseCase().execute(rsvp.getUserId())
        }
    }
}
