package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponse
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponseStatus
import com.ekoapp.ekosdk.internal.api.dto.EventRSVPDto

internal class EventResponseMapper {

    fun map(data: EventRSVPDto): AmityEventResponse {
        val eventId = data.eventId ?: ""
        val userId = data.userId ?: ""
        
        return AmityEventResponse(
            rsvpId = "${eventId}_${userId}",
            status = AmityEventResponseStatus.enumOf(data.status),
            eventId = eventId,
            event = null,
            userId = userId,
            user = null,
            createdAt = data.createdAt ?: org.joda.time.DateTime.now(),
            respondedAt = data.respondedAt,
            updatedAt = data.updatedAt ?: org.joda.time.DateTime.now()
        )
    }
}
