package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.entity.social.event.EventResponseEntity
import com.ekoapp.ekosdk.internal.api.dto.EventRSVPDto

internal class EventResponseEntityMapper {

    fun map(data: List<EventRSVPDto>): List<EventResponseEntity> {
        return data.mapNotNull { dto ->
            val eventId = dto.eventId ?: return@mapNotNull null
            val userId = dto.userId ?: return@mapNotNull null
            
            EventResponseEntity().apply {
                // Generate rsvpId from eventId and userId since API doesn't provide it
                rsvpId = "${eventId}_${userId}"
                status = dto.status ?: ""
                this.eventId = eventId
                this.userId = userId
                respondedAt = dto.respondedAt
                createdAt = dto.createdAt ?: org.joda.time.DateTime.now()
                updatedAt = dto.updatedAt ?: org.joda.time.DateTime.now()
            }
        }
    }
}
